===========================================================================
 BBS: The Abacus * HST/DS * Potterville MI
Date: 05-04-93 (07:33)             Number: 101
From: KOEN LESENNE                 Refer#: NONE
  To: KIRBY WALLACE                 Recvd: NO  
Subj: Kill the speaker, kill t       Conf: (36) C Language
---------------------------------------------------------------------------
Hello Kirby!

Woensdag April 28 1993, Kirby Wallace writes to All:

 KW> Tell me, has anyone ever successfully silenced the IBM PC speaker?
 KW> I've dl'd about three of four different shareware products (none
 KW> with source), but all of them just catch BIOS "induced" beeps;
 KW> other sounds get right through.

I captured this routine a while ago in the PASCAL area ...
May be it can help you ... (check especially the end of the message)
BTW, I haven't tried it out yet !!!

; ***********************************************************************
; *                                                                     *
; * Author      B.B.Bloksma                                             *
; * Date        15/08/88                                                *
; *                                                                     *
; * File name   SOUND.ASM                                               *
; *                                                                     *
; * Purpose     Provide common error sounds for pascal                  *
; *                                                                     *
; * Subroutines :       Warble  - Sound used in error routines          *
; *                     Beep    - Sound used when wrong key pressed     *
; *                     Sweep   - Sound with upgoing frequency          *
; *                     Siren   - Sound going up and down in frequency  *
; *                                                                     *
; ***********************************************************************

                PUBLIC  WARBLE,BEEP,SIREN,SWEEP

                NAME    SOUND
CODE            SEGMENT BYTE PUBLIC 'CODE'
                ASSUME  CS:CODE

; DATA

FREQ            DW      00              ; Frequency for speaker to be set at

; -----------------------------------------------------------------------

WARBLE          PROC    FAR
                PUSH    BP
                MOV     BP,SP

                IN      AL,61h          ; Save speaker port contents
                PUSH    AX

                MOV     DX,0Bh
W_MAIN:         PUSH    DX              ; SoundSet uses DX
                MOV     FREQ,2500       ; frequency of 2500 Hz.
                CALL    SOUNDSET
                MOV     CX,2600h
W_DELAY1:
                LOOP    W_DELAY1
                MOV     FREQ,32767      ; frequency of 32767 Hz.
                CALL    SOUNDSET        ;   You can't hear this frequency
                MOV     CX,1300h
W_DELAY2:
                LOOP    W_DELAY2
                POP     DX
                DEC     DX
                JNZ     W_MAIN

                POP     AX              ; Restore speaker port contents
                AND     AL,0FDh         ; Make sure the speaker is off
                OUT     61h,AL

                POP     BP
                RET
WARBLE          ENDP

; -----------------------------------------------------------------------

BEEP            PROC    FAR
                PUSH    BP
                MOV     BP,SP
                IN      AL,61h          ; Save speaker port contents
                PUSH    AX

                MOV     FREQ,175        ; frequency of 175 Hz.
                CALL    SOUNDSET
                MOV     CX,4B4Bh
B_DELAY:
                LOOP    B_DELAY

                POP     AX              ; Restore speaker port contents
                AND     AL,0FDh         ; Make sure the speaker is off
                OUT     61h,AL
                POP     BP
                RET
BEEP            ENDP

; -----------------------------------------------------------------------

SI_TOP          EQU     5000
SI_BOTTOM       EQU     500             ; MUST be < SIREN_TOP
SI_TIMES        EQU     4               ; Number of times to go up and down
SI_SPEED        EQU     1               ; Speed at witch freq. changes

SIREN           PROC    FAR
                IN      AL,61h          ; Get speaker port contents
                PUSH    AX              ;  and save it

                MOV     CX,SI_TIMES     ; Number of times
SI_MAIN:        PUSH    CX              ; Save because slope uses CX
                MOV     FREQ,SI_BOTTOM  ; Start frequency
                MOV     BX,SI_TOP       ; End frequency
                MOV     CX,SI_SPEED
                CALL    SLOPE
                MOV     FREQ,SI_TOP     ; Start frequency
                MOV     BX,SI_BOTTOM    ; End frequency
                MOV     CX,SI_SPEED
                CALL    SLOPE
                POP     CX
                LOOP    SI_MAIN

                POP     AX              ; Restore speaker port contents
                AND     AL,0FDh         ; Make sure speaker is off
                OUT     61h,AL
                RET
SIREN           ENDP

; -----------------------------------------------------------------------

SW_START        EQU     40
SW_END          EQU     5000            ; MUST be  < SW_START
SW_SPEED        EQU     60

SWEEP           PROC    FAR
                IN      AL,61h          ; Get speaker port contents
                PUSH    AX              ;   and save it

                MOV     FREQ,SW_START   ; Start frequency
                MOV     BX,SW_END       ; End frequency
                MOV     CX,SW_SPEED
                CALL    SLOPE

                POP     AX              ; Restore speaker port contents
                AND     AL,0FDh         ; Make sure the speaker is off
                OUT     61h,AL
                RET
SWEEP           ENDP

; -----------------------------------------------------------------------

SLOPE           PROC    NEAR
                        ; FREQ has the frequency slope starts out with
                        ; BX has the frequency at which slope stops
