===========================================================================
 BBS: The Abacus * HST/DS * Potterville MI
Date: 05-13-93 (13:58)             Number: 55
From: BRIAN GODETTE                Refer#: 167
  To: STEVE HODSDON                 Recvd: NO  
Subj: SHIFTING A GRID                Conf: (36) C Language
---------------------------------------------------------------------------
>Moving left and right has got me stumped.  All I should need to do is t
>the first (or last) bit, and shift the entire bitmap left (or right) by
>bit, and restore the saved bit at the proper end.
>
>I can't see a 'C' solution to this.
>
>Anybody have any ideas, pointers to code, etc?

This code should work just fine, it's a bit "crude" but works. All it
needs to know is how wide (counting from 1) the bitmap is and how many
places to shift.

#include <dos.h>
#include <string.h>

void  bitrlr(char *bv, int count, int len)
{
   char  c, *p1, *p2;
   int   i, x;
   unsigned val1, val2;

   if (!(count % 8)) /* special case shift by multiple of 8 */
   {
      for (i = 0; i < (count/8); i++)
      {
         c = bv[len-1];
         p1 = &bv[len-1];
         p2 = p1-1;
         for (x = 0; x < len-1; x++)
            *p1-- = *p2--;
         bv[0] = c;
      }
   }
   else
   {
      if (count > 8) /* special case shift by > 8 */
      {
         for (i = 0; i < (count/8); i++)
         {
            c = bv[len-1];
            p1 = &bv[len-1];
            p2 = p1-1;
            for (x = 0; x < len-1; x++)
               *p1-- = *p2--;
            bv[0] = c;
         }
         count %= 8;
      }
      p1 = &bv[0];
      val2 = (((unsigned)bv[len-1]) << (8-count)) & 0xff;
      for (x = 0; x < len; x++, p1++)
      {
         val1 = ((unsigned)*p1) << (8-count);
         *p1 = (val1 >> 8) | (val2 & 0xff);
         val2 = val1 & 0xff;
      }
   }
}

void  bitrll(char *bv, int count, int len)
{
   char  c, *p1;
   int   i, x;
   unsigned val1, val2;

   if (!(count % 8)) /* special case shift by multiple of 8 */
   {
      for (i = 0; i < (count/8); i++)
      {
         c = bv[0];
         movedata(FP_SEG(bv+1), FP_OFF(bv+1),
                  FP_SEG(bv), FP_OFF(bv), len-1);
         bv[len-1] = c;
      }
   }
   else
   {
      if (count > 8) /* special case shift by > 8 */
      {
         for (i = 0; i < (count/8); i++)
         {
            c = bv[0];
            movedata(FP_SEG(bv+1), FP_OFF(bv+1),
                     FP_SEG(bv), FP_OFF(bv), len-1);
            bv[len-1] = c;
         }
         count %= 8;
      }
      p1 = &bv[len-1];
      val2 = ((unsigned)bv[0]) >> (8-count);
      for (x = 0; x < len; x++, p1--)
      {
         val1 = ((unsigned)*p1) << count;
         *p1 = (val1 & 0xff) | (val2 & 0xff);
         val2 = val1 >> 8;
      }
   }
}

void main()
{
   char  test[] = "U\xaaU\xaaU\xaaU\xaa";

   bitrlr(test, 1, strlen(test));
   bitrll(test, 1, strlen(test));

   bitrlr(test, 3, strlen(test));
   bitrll(test, 3, strlen(test));

   bitrlr(test, 8, strlen(test));
   bitrll(test, 8, strlen(test));

   bitrlr(test, 9, strlen(test));
   bitrll(test, 9, strlen(test));

   bitrlr(test, 11, strlen(test));
   bitrll(test, 11, strlen(test));
}

--- UltraBBS v2.09
 * Origin: The Eighth Dimension (303)-651-7745 (1:104/118.0)
SEEN-BY: 1/211 11/2 4 13/13 101/1 108/89 109/25 110/69 114/5 123/19 124/1
SEEN-BY: 153/752 154/40 77 157/2 159/100 125 575 950 203/23 209/209 261/1023
SEEN-BY: 280/1 390/1 396/1 5 15 2270/1 2440/5 3603/20
