===========================================================================
 BBS: The Abacus * HST/DS * Potterville, MI
Date: 06-06-93 (18:37)             Number: 223
From: PETER JACKSON                Refer#: 198
  To: ROLLIN WHITE                  Recvd: NO  
Subj: Parsing a Text file            Conf: (36) C Language
---------------------------------------------------------------------------
 -=> Quoting Rollin White to All <=-

 RW> Does anyone have code(or even a reccommended
 RW> approach) fo reading in a text file that will serve as a
 RW> program's configuration file?  Specifically, keywords like:

 RW> USER=John Doe

 RW> Any ideas are appreciated!

Here's one idea. It started out as a quick thing centered
around strtok(), but it, as usual, proved a little more
complex to write when trying to handle multi word values
ie. "John Doe". Anyway, this is tested and works.

#include <stdio.h>
#include <string.h>

#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif

void main()
{
    char    option[30],     /* arbitrary length */
            value[30],      /* arbitrary length */
            buf[60],        /* arbitrary length */
            first,          /* flags multiple words for value */
            *ptr;
    FILE    *fpi;

    if( (fpi=fopen("MYFILE.CFG", "r")) == (FILE *)NULL )
    {
        perror("Could not open MYFILE.CFG");
        return;
    }

    memset(option, '\0', sizeof(option));
    memset(buf, '\0', sizeof(buf));
    ptr=(char *)NULL;

    while( fgets(buf, sizeof(buf), fpi) )       /* read one full line */
    {
        memset(value, '\0', sizeof(value));
        first=TRUE;
        buf[strlen(buf)-1]='\0';           /* change \n to \0 */
        strcpy(option, strtok(buf, "= \t"));

        /* this block handles 'multi-word' values */
        while( ptr=strtok((char *)NULL, "= \t") )   /* look for word */
        {
            if( !first )        /* seperate words in value */
                strcat(value, " ");
            first=FALSE;
            strcat(value, ptr);
        }
        /* ... process option ... */
printf("Option: [%s]\tValue: [%s]\n", option, value);   /* debug */
    }

    fclose(fpi);
}

/* Here is a sample config file that tests various input possibilities */

#ifdef CompileTestDataAndBlowUp
SETUP=setup
OTHER = other
SOME= some
WHAT =what

BLANK=did you get that?
TAB =   tab
#endif


Hope it's of some use.

-pbj-

... Post no bills
___ Blue Wave/QWK v2.12

--- Maximus/2 2.01wb
 * Origin: Treasure Island =HST/DS= 203-791-8532 (1:141/730)
SEEN-BY: 1/211 11/2 4 13/13 101/1 108/89 109/25 110/69 114/5 123/19 124/1
SEEN-BY: 153/752 154/40 77 157/110 159/100 125 430 575 950 203/23 209/209
SEEN-BY: 261/1023 280/1 390/1 396/1 5 15 2270/1 2440/5 3603/20
