===========================================================================
 BBS: The Abacus * HST/DS * Potterville, MI
Date: 06-06-93 (11:26)             Number: 218
From: DANIEL LYNES                 Refer#: NONE
  To: MATTHEW O'CONNOR              Recvd: NO  
Subj: Mod File Routines 2/4          Conf: (36) C Language
---------------------------------------------------------------------------
#include <stdio.h>
#include <stdlib.h>
#include <mem.h>
#include <io.h>
#include <fcntl.h>
#include "MOD2.h"

/**************/
/** Functions**/
/**************/

void Print_Inst(struct S_Inst *inst)
{
 printf("Name         :%s\n",inst->Name);
 printf("Lenght       :%u\n",inst->Len);
 printf("Fine Tune    :%u\n",inst->F_Tune);
 printf("Volume       :%u\n",inst->Vol);
 printf("Repeat Start :%u\n",inst->R_Start);
 printf("Repeat Length:%u\n",inst->R_Len);
};

void Print_Note(struct S_Note *note)
{
 printf("Samp num: %.2i  ",note->Num);
 printf("Perriod : %.4u  ",note->Period);
 printf("Effect  : %.4u \n",note->Effect);
};

void Print_Chan(struct S_Channel *chan)
{
 int i;
 for ( i = 0; i < MAXCHAN ; i ++)
 Print_Note(&chan->Chan[i]);
};


void Print_Track(struct S_Track *track)
{
 int c;

 for (c=0; c < MAXNOTES ; c++)
  {
   Print_Chan(&track->Note[c]);
   printf("------------------------\n");
  };
};
/*******************************/
/****    Mod File Loading   ****/
/**** Function Declarations ****/
/*******************************/

word Con_Word(char *ptr)
/* This function takes the word pointed to by ptr and switches
  the high/low bytes to change from amiga to pc. It also multiplies
  the result by two to convert words to bytes.   */
{
  word w;   /* temporary word  */
  byte h,l; /* temporary bytes */

  h = *(ptr + 1);
  l = *ptr;
  w = (l * 256) + h;
  w = w * 2; /* to convert # words to # of bytes. */
  return(w);
};

/*********
 *********/

void Read_Note(struct S_Note *note, int handle)
/* this function seperates the 4 bytes of a note into their
propper catagories */
{
 char* ptr;
 byte t[4];

 _read(handle,t,4);

 note->Num = (t[0]&240) + ((t[2]&240)/16);
 /*          11110000       11110000 >> 00001111 */
 note->Period  = (t[0]&15) * 256;
 note->Period += t[1];
 /*             00001111 << 111100000000     */
 note->Effect  = (t[2]&15) *256;
 note->Effect += t[3];
};


/*********
 *********/

void Read_Inst (struct S_Inst *inst, int handle)
/*  This function loades ONE instrament.  It puts the information into the inst
structure.  "m_ptr" shows the function where the instrament starts at. */

{
 char *cptr,       /* counting pointer  */
 ptr;              /* temporary pointer */
 int i;            /* temporary integer */
 char t[30];       /* temporary buffer  */

 _read(handle,t,30);

 cptr = t;         /* point to beginning of buffer */
 /*** Load Instrament Name ***/
 memcpy(&inst->Name,cptr,22);
 memcpy(&inst->Name[22],"\0",1);
 cptr += 22;

 /*** Get Instrament Length ***/
 inst->Len = Con_Word(cptr); /* correct word */
 cptr += 2;

 * SLMR 2.1a * Beware of quantum ducks:  quark, quark.

--- SLMAIL v3.0  (#0272)
 * Origin: Thunder Bay, Ontario, Canada (1:229/516)
SEEN-BY: 1/211 11/2 4 13/13 101/1 108/89 109/25 110/69 114/5 123/19 124/1
SEEN-BY: 153/752 154/40 77 157/110 159/100 125 430 575 950 203/23 209/209
SEEN-BY: 261/1023 280/1 390/1 396/1 5 15 2270/1 2440/5 3603/20
