===========================================================================
 BBS: The Abacus * HST/DS * Potterville MI
Date: 05-09-93 (14:22)             Number: 31
From: MARK CORGAN                  Refer#: NONE
  To: ALL                           Recvd: NO  
Subj: LOOKUP.C & DEFINES.H           Conf: (36) C Language
---------------------------------------------------------------------------
--->CONTINUED FROM PREVIOUS MESSAGE<---

/* DEFINES.H */

#define MAX_LINE           40     /* maximum line length */
#define MAX_KEY            26     /* maximum key size    */
#define ASCII_FILE  "info.dat"    /* the data base       */
#define INDEX_FILE  "info.ndx"    /* the index file      */
#define END_REC         ".\n"     /* end of a record     */
#define TRUE                1     /* for BOOLEAN         */
#define FALSE               0

typedef char BOOLEAN;             /* data type */

struct index_rec                  /* index record */
{
   char key[MAX_KEY];             /* name */
   long pos;                      /* position */
};

typedef struct index_rec INDEX;

/* LOOKUP.C */

#include <stdio.h>
#include "index.h"

long bsearch(FILE *ifp, long first, long last, char *target);
FILE *my_fopen(char *file_name, char *mode);

void main(void)
{
   FILE *afp, *ifp;
   char line[MAX_LINE];
   INDEX header;
   long pos;

   afp = my_fopen(ASCII_FILE, "r");
   ifp = my_fopen(INDEX_FILE, "rb");
   if(fread((char *) &header, sizeof(INDEX), 1, ifp) == 0)
      fprintf(stderr, "Can't read header of \"%s\"\n", INDEX_FILE);
   else
      while(printf("Name? "), fgets(line, sizeof(line), stdin))
         if((pos = bsearch(ifp, 1L, header.pos, line)) == -1)
            printf("Couldn't find: %s\n", line);
         else if(fseek(afp, pos, 0) != 0)
            fprintf(stderr, "Can't read record at position %ld\n", pos);
         else
            while(fgets(line,sizeof(line),afp) && strcmp(line,END_REC)!=0)
               fputs(line, stdout);
   fclose(ifp);
   fclose(afp);
   exit(0);
}

long bsearch(FILE *ifp, long first, long last, char *target)
{
   long pos, mid =(first + last) / 2;
   INDEX next;
   int cmp;

   if(mid < first || fseek(ifp, mid * sizeof(INDEX), 0) != 0 ||
            fread((char *) &next, sizeof(INDEX), 1, ifp) == 0)
      pos = -1;
   else
      pos = ((cmp = strncmp(target, next.key, MAX_KEY)) == 0)
                ? next.pos
                : ((cmp < 0) ? bsearch(ifp, first, mid - 1, target)
                             : bsearch(ifp, mid + 1, last, target));
   return pos;
}

FILE *my_fopen(char *file_name, char *mode)
{
   FILE *fp = fopen(file_name, mode);

   if(!fp)
   {
      fprintf(stderr, "Can't open file \"%s\" for %s\n", file_name,
                      (*mode == 'r')
                           ? "reading"
                           : ((*mode == 'w') ? "writing" : "appending"));
      exit(1);
   }
   return fp;
}

/* end of LOOKUP.C */

The ASCII text file's format is as follows:

Mark Corgan
550 Foothill Rd.
Gardnerville, NV 89410
(702) 265-2388
.
Hello World
123 Anywhere St.
Anytown, CA 12345
(123) 456-7890
.
etc...

The period is what LOOKUP.C looks for to indicate the end of record. Of course,
you could have any format you like, so long as the first line is the information
 you are looking for. Also, there is no limit to the number of lines of infomati
on after the first line and before the period as fputs() continues until the per
iod. Enjoy!



Mark

--- GoldED 2.40
 * Origin: -*- Sound and Image -*-  (1:213/810)
SEEN-BY: 1/211 11/2 4 13/13 101/1 108/89 109/25 110/69 114/5 123/19 124/1
SEEN-BY: 153/752 154/40 77 157/2 159/100 125 575 950 203/23 209/209 261/1023
SEEN-BY: 280/1 390/1 396/1 5 15 2270/1 2440/5 3603/20
