===========================================================================
 BBS: The Abacus * HST/DS * Potterville MI
Date: 05-12-93 (10:32)             Number: 18
From: PETER SMITH                  Refer#: 109
  To: STEPHAN GALT                  Recvd: NO  
Subj: visibility                     Conf: (36) C Language
---------------------------------------------------------------------------
 On 05-10-93 Stephan Galt wrote to All...

 SG> Also a question has come up about the actual records I
 SG> want to include in the structures.  Basically each struct
 SG> would contain one string and a pointer to the next struct.
 SG> The strings( to be read in from a file ) are of different
 SG> lengths.  Can these be accomidated, or must they be 'forced'
 SG> to be a given maximum (for example by char string[50];)?

Here is some code to get you started, (Its TESTED). This way your strings can
be of nearly any size without wasting space. I've included one of the struct
definitions. This is from an indexed dictionary, which used a link list for
storage (sounds similar to what you are doing).
I used my own function "selfError" but you can simply use a puts(); instead.

// Function to allocate space for a link in a link list.
// by Peter Smith 1993
// Donated to the Public Domain

typedef struct alink{
    char *key;
    char *value;
    struct alink *next;
    }ALINK;     // template for one link of linked list and define as a type

typedef ALINK *List;      // define type as ptr to ALINK

List makeSpaceForEntries(string akey, string value)
{   // Private - allocate space for a new link and store the key/value pair
    // in it and return pointer to it. Copies the value (and key when new)
    // into heap space as simply storing the pointer does not work due to
    // the object being pointed could be on the stack and may disappear.
    // operation is expensive.
    List alink;


    alink = (List) malloc( sizeof (ALINK) );
    if(alink == NULL)
    {
        selfError("unable to allocate more memory for dictionary");
        exit(1);
    }
                                        // next allocate space for input string
    alink->value = (char *) malloc(strlen(value) + 1);
    if(alink->value == NULL)
    {
        selfError("Unable to allocate more memory for value");
        exit(1);
    }
    strcpy(alink->value, value);        // copy string into space
                                        // next allocate space for key input
    alink->key = (char *) malloc(strlen(akey) + 1);
    if(alink->key == NULL)
    {
        selfError("Unable to allocate more memory for key");
        exit(1);
    }
    strcpy(alink->key, akey);           // copy string into space
    alink->next = NULL;                 // as this is the last one in the list
    return(alink);
}

// end of code (as if you didn't know <g>!) ..........Pete

... OFFLINE 1.50  "God does not speak out of a gun barrel."

--- Maximus 2.01wb
 * Origin: Ned's Opus * Northern FDN Connection * (1:243/15)
SEEN-BY: 1/211 11/2 4 13/13 101/1 108/89 109/25 110/69 114/5 123/19 124/1
SEEN-BY: 153/752 154/40 77 157/2 159/100 125 575 950 203/23 209/209 261/1023
SEEN-BY: 280/1 390/1 396/1 5 15 2270/1 2440/5 3603/20
