===========================================================================
 BBS: The Abacus * HST/DS * Potterville, MI
Date: 04-25-93 (19:57)             Number: 27
From: BOB STOUT                    Refer#: 23
  To: GENE SENYSZYN                 Recvd: NO  
Subj: formatting a floppy            Conf: (36) C Language
---------------------------------------------------------------------------
In a message of <Apr 22 03:40>, Gene Senyszyn (1:2606/213@fidonet) writes:

 >How does one go about formatting a floppy(not meaning shelling and running
 >format) in C? If possible, post a small example about how to go about doing
 >it, as I seem to be stuck.

  From SNIPPETS, here's a heavy-handed approach which calls FORMAT, but does it
transparently. The advantage, of course, is that it makes the executable very sm
all.

/*
**  FORMAT.C - Use DOS FORMAT to format a diskette
**
**  Original Copyright 1992 by Bob Stout as part of
**  the MicroFirm Function Library (MFL)
**
**  This subset version is hereby donated to the public domain.
*/

#include <stdio.h>
#include <stdlib.h>

enum {ERROR = -1, SUCCESS};

/*
**  format
**
**  Formats a specified floppy disk with optional switches.
**
**  Parameters: 1 - Drive letter ('A', 'B', ...) to format
**              2 - Formatting switches in FORMAT.COM format, e.g. "/4"
**              3 - Volume label
**
**  Returns: SUCCESS or ERROR
*/

int format(char drive, char *switches, char *vlabel)
{
      char command[128], fname[13];
      FILE *tmpfile;

      tmpnam(fname);
      if (NULL == (tmpfile = fopen(fname, "w")))
            return ERROR;                       /* Can't open temp file */
      fprintf(tmpfile, "\n%s\nN\n", vlabel);
      fclose(tmpfile);

      sprintf(command, "format %c: /V %s < %s > NUL", drive, switches, fname);

      system(command);

      remove(fname);

      return SUCCESS;
}

#ifdef TEST

void main(void)
{
      int retval = format((char)'a', "/4", "dummy_test");

      printf("format() returned %d\n", retval);
}

#endif


--- QM v1.00
 * Origin: MicroFirm : Down to the C in chips (1:106/2000.6)
SEEN-BY: 1/211 11/2 4 13/13 101/1 108/89 109/25 110/69 114/5 123/19 124/1
SEEN-BY: 153/752 154/40 77 157/2 159/100 125 575 950 203/23 209/209 280/1
SEEN-BY: 390/1 396/1 5 15 2270/1 2440/5 3603/20
