===========================================================================
 BBS: The Abacus * HST/DS * Potterville, MI
Date: 04-27-93 (09:14)             Number: 170
From: RAY GARDNER                  Refer#: 206
  To: NATE WRIGHT                   Recvd: NO  
Subj: PARTITIONS                     Conf: (36) C Language
---------------------------------------------------------------------------
[Nate Wright to All:]
 > Hi, I was wondering if there is a way to determine the number of
 > logical drives on a system?  This would include floppies, hard disk
 > partitions, ram drives, swapped drives, or any other type of drive
 > that can be recognized by DOS.  I've tried just fopen and a test to
 > see if a file opened (I'm looking for a specific file), but that just
 > produces Borland C runtime error message of Drive Not Ready.  I've
 > also tried a couple of int 0x21 functions, but they don't recognize
 > ram and swapped drives.  I've also tried the int 0x13 functions, but
 > they only work for physical drives.  Anyone have any idea?

Here's an int 0x21 function you probably missed:

/* drives.c -- detect all valid drive letters (logical drives)
**
** public domain by Ray Gardner  4/93
**
** uses DOS int 21 function 29 (parse filename)
** does not activate drive, so does not get "drive not ready" status
*/
#include <stdio.h>
#include <string.h>

#include <dos.h>

int is_valid_drive(int drive_letter)
{
    union REGS reg;
    struct SREGS segs;
    char drive[4], fcb[36];

    strcpy(drive, " :");
    drive[0] = drive_letter;
    segread(&segs);
    segs.ds = FP_SEG(drive);
    reg.x.si = FP_OFF(drive);
    segs.es = FP_SEG(fcb);
    reg.x.di = FP_OFF(fcb);
    reg.x.ax = 0x2900;
    int86x(0x21, &reg, &reg, &segs);
    return reg.h.al != 0xFF;
}

int main(void)
{
    int i;

    printf("Valid drives are: ");
    for ( i = 'a'; i <= 'z'; ++i )
        if ( is_valid_drive(i) )
            printf("%c ", i);
        printf("\n");
    return 0;
}


--- msged 1.99S ZTC
 * Origin: Ray Gardner -- Englewood, CO (1:104/89.2)
SEEN-BY: 1/211 11/2 4 13/13 101/1 108/89 109/25 110/69 114/5 123/19 124/1
SEEN-BY: 153/752 154/40 77 157/2 159/100 125 575 950 203/23 209/209 280/1
SEEN-BY: 390/1 396/1 5 15 2270/1 2440/5 3603/20
