===========================================================================
 BBS: The Abacus * HST/DS * Potterville MI
Date: 05-18-93 (21:26)             Number: 32
From: SVEN VAN DE VELDE            Refer#: NONE
  To: NEIL CUNNINGHAM               Recvd: NO  
Subj: HARD DRIVE IDENTITY            Conf: (36) C Language
---------------------------------------------------------------------------
Hi Neil,

 NC> I'm kinda new to C so, I need some help.  I'm trying to write a simple
 NC> program that will determine all the hardware installed on any
 NC> computer. The
 NC> only problem I've run into is that I can't figure out how to extract
 NC> the hard
 NC> drive types from CMOS. Any help would greatly appreciated. This is the
 NC>  beginning of what might be a rather large project for the U.S. Navy
 NC> (which I
 NC>  am in) to assist in ADP security. Again Thanks in advance!



 Try BIOS interrupt 11h.

 It returns a 16 bit value in the AX register.

 bitnr.

 0              equals 1 if the system has one or more disk drives.
 1              not used.
 2 and 3        the amount of RAM on the main board.
                00 = 16KB
                01 = 32KB
                10 = 48KB
                11 = 64KB
 4 and 5        screen mode at startup.
 6 and 7        amound of disk drives if bit 0 is set!
                                      ---------------
                00 = 1 disk
                01 = 2 disks
                10 = 3 disks
                11 = 4 disks

 Now, how do you determine WHICH hard drive is attached? Well, use the
 interrupt service routine 41h (for hard disk 0) or 46h (for hard disk 1)
 of BIOS.  These interrupts are pointing to a table that describes the
 contents concerning the hard disks. The BIOS knows lots of these tables
 standardly, so that BIOS adapt the hard disk available at startup.
 Sadly, I don't know how the the processor registers or memory react at these
 interrupt functions. (The information in my book isn't detailed for
 security reasons. Hard disk crashes etc.)
 But I hope that this is a start for more searching.
 Or try this routine...

 /* DISKTYPE.C *****************************************************
    program to get disk information via BIOS call 0x440d, minor
    function 0x60, compile with byte alignment option in Zortech for
    example ZTC -a1 disktype
    ****************************************************************/
#include <dos.h>
#include <stdlib.h>

#include <stdio.h>

main(int argc, char *argv[])
{
    struct {
        char    SpecialFunction;
        char    DeviceType;
        int     DeviceAttributes;
        int     Cylinders;
        char    MediaType;
        int     BytesPerSector;         /* bpb begins */
        char    SectorsPerCluster;
        int     ReservedSectors;
        char    NumberOfFATs;
        int     RootDirEntries;
        int     Sectors;
        unsigned char    MediaDescriptor;
        int     FATSectors;
        int     SecPerTrack;

        int     Heads;
        long    HiddenSectors;
        long    HugeSectors;            /* used if Sectors returns 0 */
    } bpbstruc;
    union REGS r;
    struct SREGS s;
    char *errors[] = {"Invalid function request",
                      "Invalid drive ID",
                      " ",
                      " ",
                      "Access denied"};
    int drive = 0;              /* default drive */
    if (argc < 2)              /* no drive specified */
    {
        printf("Error: no drive specified.\n");
        printf("Usage: disktype <drive>\n");
        return(1);
    }
    /* make upper case */

    drive =(argv[1][0] >= 'a' && argv[1][0] <= 'z') ?
                argv[1][0] - 'a' + 'A' : argv[1][0];
    drive -= 'A' - 1;       /* 1 = A, 2 = B . . . */
    r.x.ax = 0x440d;              /* function call */
    r.x.bx = drive;               /* drive identifier */
    r.x.cx = 0x0860;           /* minor function 60, ch must = 8*/
    r.x.dx = (unsigned int) &bpbstruc;      /* offset of struct */
    s.ds = (unsigned int)((long) &bpbstruc>>16);   /* segment of struct */
    intdosx(&r,&r,&s);

    /* now you should be able to read the info if there were no errors */
    /* check the carry flag, and if set, error number is returned in AX */
    if (r.x.cflag != 0)
        printf("Error %d: %s",r.x.ax,errors[r.x.ax]);
    else
    {
        printf("Information for drive %c\n",drive + 'A' - 1);
        printf("Special function: %d\n", bpbstruc.SpecialFunction);
 --- TBBS v2.1/NM
 * Origin: Autodesk Global Village (1:125/289)
SEEN-BY: 1/211 11/2 4 13/13 101/1 108/89 109/25 110/69 114/5 123/19 124/1
SEEN-BY: 153/752 154/40 77 157/2 159/100 125 575 950 203/23 209/209 261/1023
SEEN-BY: 280/1 390/1 396/1 5 15 2270/1 2440/5 3603/20
