===========================================================================
 BBS: The Abacus * HST/DS * Potterville MI
Date: 05-03-93 (21:32)             Number: 48
From: RAY GARDNER                  Refer#: NONE
  To: LES FENISON                   Recvd: NO  
Subj: Determining heap memory l      Conf: (36) C Language
---------------------------------------------------------------------------
 > Does anyone have any routines to determine how much memory is actually
 > available on the heap including freed memory located before the last
 > allocated?

For use in large or compact model, where there is no separate far heap (i.e. the
 only heap is the far heap):

/* memleft() -- find remaining available memory
**  public domain by Ray Gardner 4/93
**
**  Allocate (then free) all remaining memory to determine
**  how much is left.  Set allocated bytes to val.  (This is valuable
**  for debugging, when val turns up where it doesn't belong.)
*/
#include <stdlib.h>
#include <string.h>

typedef struct NODEtag {
    struct NODEtag *next;
    } NODE;

long memleft(unsigned val)
{
    long total = 0;
    unsigned k;
    NODE *p, *list = 0;

    for ( k = 32768U; k >= sizeof(NODE *); )
    {
        if ( (p = (NODE *)malloc(k)) == 0 ) {
            k /= 2;
        }
        else
        {
            total += k;
            memset((void*)p, val, k);
            p->next = list;
            list = p;
        }
    }

    while ( list )
    {
        p = list->next;
        memset((void *)list, val, sizeof(NODE *));
        free((char *)list);
        list = p;
    }

    return total;
}

#ifdef TEST
#include <stdio.h>
int main(void)
{
    printf("%ld\n", memleft(0xCF));
    return 0;
}
#endif

I have a similar function for use in checking the far heap from a small model pr
ogram.  I can post it if you need it, or perhaps you'd like to try adapting this
 one.



--- msged 1.99S ZTC
 * Origin: Ray Gardner -- Englewood, CO (1:104/89.2)
SEEN-BY: 1/211 11/2 4 13/13 101/1 108/89 109/25 110/69 114/5 123/19 124/1
SEEN-BY: 153/752 154/40 77 157/2 159/100 125 575 950 203/23 209/209 280/1
SEEN-BY: 390/1 396/1 5 15 2270/1 2440/5 3603/20
