#if !defined( __STOPWATCH_H )
#define __STOPWATCH_H

#if !defined( __DOS_H )
#include <Dos.h>
#endif

// StopWatch is based on the system timer.

// Class
//
//	StopWatch
//
// Purpose
//
//  Uses the system timer to time events.
//
// Methods
//
//	StopWatch()					constructor
//
//		Calls start() to start the watch.
//
//	start()
//
//		Records the current timetick count in member begin.
//
//	elapsed()
//
//		Returns the difference between the current timetick count
//		and begin. Result is the number of timeticks (1/18.2 sec)
//		that have occurred since begin() was last called.

class StopWatch
	{
	public:
		StopWatch();

		void start();
		unsigned long elapsed();

	protected:
		unsigned long begin;
		static volatile unsigned long far *timePtr;
	};

//-------------------------------------------------------------
// Class STOPWATCH	method		constructor		inline
//-------------------------------------------------------------

inline StopWatch::StopWatch()
	{
	// initialize member begin.
	start();
	}

//-------------------------------------------------------------
// Class STOPWATCH	method		start()			inline
//-------------------------------------------------------------

inline void StopWatch::start()
	{
	// initialize member begin. Member timePtr points to a BIOS
	// memory location that is incremented 18.2 times per second.
	begin = *timePtr;
	}

//-------------------------------------------------------------
// Class STOPWATCH	method		elapsed()		inline
//-------------------------------------------------------------

inline unsigned long StopWatch::elapsed()
	{
	// returns the number of timeticks that have elapsed since
	// begin was last initialized (either with the constructor
	// or through a call to start()). Member timePtr points to
	// a BIOS memory location that is incremented 18.2 times
	// per second.
	return (*timePtr - begin );
	}

#endif	// __TIMER_H
