#if !defined( __TIMER_H )
#define __TIMER_H

class Timer
	{
	public:
		Timer();

		void start();
		unsigned long elapsed();

	protected:
		unsigned long begin;
		static volatile unsigned long far *timePtr;
	};

inline Timer::Timer()
	{
	start();
	}

inline void Timer::start()
	{
	begin = *timePtr;
	}

inline unsigned long Timer::elapsed()
	{
	return (*timePtr - begin );
	}

#endif	// __TIMER_H
