#if !defined( __COMSTREAM_H )
#define __COMSTREAM_H

#if !defined( __IOSTREAM_H )
#include <Iostream.h>
#endif	// __IOSTREAM_H

#define NUMBEROFPORTS	4

#define TIMEOUT		1
#define OR			2
#define PE			4
#define FE			8
#define BI			16

#define	DTR	1
#define MCR	4

#define HW_HANDSHAKE	1
#define SW_HANDSHAKE	2
#define WAITFORECHO		4

#define NO_PARITY	0
#define ODD_PARITY	1
#define EVEN_PARITY	2

class combuf;

struct ComDef
	{
	unsigned portAddr;
	unsigned char irqAddr;
	unsigned char picMask;

	ComDef( int );
	~ComDef();

	void setParams( int, int, int );

	protected:
		friend class combuf;

		int  setCombuf( combuf * );
		void clrCombuf();

		void interrupt far (*oldhandler)(...);
		combuf *owner;
	};

struct CommProtocol
	{
	long baud;
	int bits, parity, stopBits;

	CommProtocol( long, int, int, int );
	};

inline CommProtocol::CommProtocol( long b, int bt, int p, int sb ) : baud(b), bits(bt),
		parity(p), stopBits(sb)
	{}

class combuf : public streambuf
	{
	public:
		static ComDef def[NUMBEROFPORTS];

		enum ParityType {	none, odd, even };

		combuf(char *, int, int );
		combuf();
		~combuf();

		virtual	streambuf *setbuf( signed char *, int );
		combuf *setbuf( char *, int, int );

		virtual	int underflow();

		virtual int do_sputn( const char *, int );
		virtual int overflow( int = EOF );

		void setPort( int = EOF );
		void setTimeout( unsigned long );
		void setInterCharDelay( unsigned long );
		void setInterLineDelay( unsigned long );

		void setOption( int );
		void clearOption( int );

		void setBaud( long );
		void setParity( int );
		void setBits( int );
		void setStopBits( int );
		void setParams( CommProtocol& );

		void assertDTR();
		void unassertDTR();

		int  status();

		friend class comstream;

	protected:
		friend struct ComDef;

		int offs_;
		int errFlags,options;
		int inSize;

		unsigned long timeout_;
		unsigned long ibdelay_;
		unsigned long ildelay_;

		int extractc();
		int insertc( int );

		unsigned long timeToTicks( unsigned long );

		void assertToPort( int, int );
		void unassertToPort( int, int );

	static void interrupt far handler0x0B(...);
	static void interrupt far handler0x0C(...);
		void handleIRQ( int, int, int );
	};

inline void combuf::assertDTR()
	{
	if( offs_ != EOF )
		assertToPort( MCR, DTR );
	}

inline void combuf::unassertDTR()
	{
	if( offs_ != EOF )
		unassertToPort( MCR, DTR );
	}

inline int combuf::status()
	{
	int n = errFlags;
	errFlags = 0;
	return n;
	}

inline void combuf::setOption( int i )
	{
	options |= i;
	}

inline void combuf::clearOption( int i )
	{
	options &= ~i;
	}

class _CLASSTYPE comstream : public iostream
	{
	public:

		_Cdecl comstream();
		_Cdecl comstream( char _FAR *, int, int );
		_Cdecl ~comstream();

		combuf _FAR * _Cdecl rdbuf();
		void _Cdecl open( int );
		void _Cdecl close();

	private:

		combuf buf;
	};

inline combuf *comstream::rdbuf()
	{
	return &buf;
	}

typedef comstream& (*CSLongManip)(comstream&, long);
typedef comstream& (*CSIntManip)(comstream&, int);

class ComManipLong
	{
	public:
		ComManipLong( CSLongManip f, long l) : fn(f), arg(l)	{}

		friend comstream& _Cdecl operator<<(comstream& cs, ComManipLong& f )
			{
			return (*f.fn)(cs, f.arg);
			}

	private:
		CSLongManip fn;
		long arg;
	};

class ComManipInt
	{
	public:
		ComManipInt( CSIntManip f, int i) : fn(f), arg(i)	{}

		friend comstream& _Cdecl operator<<(comstream& cs, ComManipInt& f )
			{
			return (*f.fn)(cs, f.arg);
			}

	private:
		CSIntManip fn;
		int arg;
	};

ComManipLong cdecl baud( long );
ComManipInt  cdecl bits( int );
ComManipInt  cdecl parity( int );
ComManipInt  cdecl stopbits( int );
ComManipLong cdecl timeout( long );
ComManipInt  cdecl intercharDelay( int );
ComManipInt  cdecl interlineDelay( int );


#endif	// __COMSTREAM_H
