/* Programmer          : Paul McKenzie   Phone # (212) 714-4027.
 * Date Written        : 8/14/89
 * Restrictions on Use : None
 * Compilers Tested    : Microsoft C 5.1    Turbo C 2.0
 *
 *
 * This subroutine will return a comma formatted string of digits.
 * The routine needs two things:
 *
 * 1)  The original number must be represented as a 0 terminated string of
 *     digits.  You can use sprintf() to do this.
 *
 * 2)  A buffer that will hold the newly formatted string of numbers.  This
 *     buffer must be capable of holding the original string, plus any commas
 *     that the string may have.
 */



#include <stdio.h>
#include <string.h>
#include <ctype.h>


char *comma_fmt();

char *comma_fmt(buf,   /* Pointer to string of numbers */
                buf2  /* Pointer to buffer to hold the formatted number */
               )

char *buf,
     *buf2;
{
  int ints,       /* Number of integers in number */
      l,          /* length of number, including commas */
      ncommas,    /* Number of commas in number */
      c,          /* Indexes original number string */
      d,          /* Indexes formatted number string */
      cnt,        /* keeps track if we should place a comma */
      dp,         /* position of decimal point */
      sfound = 0, /* 1 if number signed, o otherwise */
      l2 = strlen(buf);
      char *b1,
           *b2;

  /* First check to see how many integer digits there are */
  for (c = ints = 0; ((*(buf+c) && *(buf+c) != '.'));c++)
  {
    if (*(buf+c) == '-' || *(buf+c) == '+')
      sfound = 1;  /* Found a sign */
    ints += (*(buf+c) >= '0' && *(buf+c) <= '9');
  }

  /* Check if we should do anything */
  if (ints > 3)
    ncommas = ints/3 - ((ints %3) == 0);
  else    /* return number , <= 3 digits */
  {
    strcpy(buf2,buf);
    return buf2;
  }
  l = l2+ncommas;   /* get total length of formatted number */
  d = ints + ncommas + sfound;
  dp = strcspn(buf,"."); /* get position of decimal point */

  if (dp < l2)       /* adjust if decimal point found */
    l2 = l2-dp;
  else
    l2 = 0;

  memset(buf2,0,l);
  b1 = buf+(--c);
  b2 = buf2+(--d);
  cnt = 0;

  /* loop to build comma formatted number */
  for (;c>=0;c--)
  {
    if (*b1 == '-' || *b1 == '+')
    {
      /* copy sign over */
      *b2 = *b1;
      b2--;
    }
    else
    if (isdigit(*b1))
    {
      if (cnt == 3)
      {
        /* place comma in formatted string */
        *b2 = ',';
        b2--;
        cnt = 0;
      }
      /* copy digit over */
      *b2 = *b1;
      b2--;
      cnt++;
    }
    b1--;
  }
  if (dp < l)
    /* copy decimal portion of the number into newly formatted number */
    memcpy(buf2+ints+ncommas+sfound,buf+dp,l2);
  *(buf2+l) = 0;  /* stick NULL on end */
  return buf2;
}

/* This is a sample of how to use comma_fmt */

main()
{
  char buffer[20];
  char temp[20];
  double num;
  while (1)
  {
    printf("\nEnter a number : ");
    scanf("%lf",&num);
    sprintf(temp,"%-12.2lf",num);   /* Try different formats */
    comma_fmt(temp,buffer);
    printf("\nThe number formatted is %s",buffer);
  }
}
