//=======================================================================//
// COLORCDL.CPP released to the public domain 5/21/92 by Bob Bourbonnais  //
//        Demonstrates using a Windows 3.1 Color Common Dialog Box       //
//             with C++ and the Object Windows Class Library             //
//=======================================================================//
#include <owl.h>        // for Object Windows
#include <static.h>     // for static control
#include <dialog.h>     // for dialog boxes
#include <commdlg.h>    // for Win 3.1 Common Dialogs.  You need the
                        // Compatibility kit or SDK 3.1 to get this
                        // header file
#include "colorcdl.h"
//=======================================================================//
_CLASSDEF(TColorDialog)               // Class to encapsulate
class TColorDialog : public TDialog   // the Windows 3.1
  {                                   // Color Common Dialog
  public:
    DWORD dwCustClrs[16];             // Array for custom colors
    TColorDialog(PTWindowsObject AParent, // Constructor
		 DWORD * dwNewColor, LPSTR lpName, PTModule AModule);
    virtual BOOL Create();            // Create for non-modal Creation
    virtual int Execute();            // Execute for modal Execution
    #pragma argsused                  // Ignore ARetValue non use
    virtual void CloseWindow(int ARetValue){}; // trap destruction
  protected:
    CHOOSECOLOR ccdlg;                // Color Common Dialog Structure
    DWORD *dwColor;                   // Color Variable
  };
// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
TColorDialog::TColorDialog(PTWindowsObject AParent, DWORD * dwNewColor,
				   LPSTR AName,PTModule AModule = NULL)
	     :TDialog(AParent,AName,AModule) // Constructor calls base
  {
  dwColor =  dwNewColor;        //equate color address to allow updating
  int Count;                    //initialize the 16 custom colors to
  for (Count = 0; Count <= 15; Count++) // Shades of blue
    dwCustClrs[Count] = RGB(Count*(255/15),Count*(255/15),255);
  ccdlg.lStructSize    = sizeof(CHOOSECOLOR);    // initialize ccdl struct
  ccdlg.hwndOwner      = GetFocus();             // parent has the focus
  ccdlg.hInstance      = NULL;                   // Not Used for default dlg
  ccdlg.rgbResult      =  *dwNewColor;           // Color in
  ccdlg.lpCustColors   = (LPDWORD)(dwCustClrs);  // array of blue colors
  ccdlg.Flags          = CC_FULLOPEN|CC_RGBINIT; // full dialog with color in
  ccdlg.lCustData      = 0L;                     // Use Default Data
  ccdlg.lpfnHook       = (FARPROC)NULL;          // No Message trapping
  ccdlg.lpTemplateName = (LPSTR)NULL;            // Use Default dialog
  };
BOOL TColorDialog::Create()                      // Called by MakeWindow
  {
  ccdlg.hwndOwner = NULL;                        // No parent for non-Model
  ChooseColor(&ccdlg);                           // ccdlg function call
  *dwColor = ccdlg.rgbResult;                    // Color out
  return 1;                                      // Success
  }
int TColorDialog::Execute()                      // Called by CreateDialog
  {
  ChooseColor(&ccdlg);                           // ccdlg function call
  *dwColor = ccdlg.rgbResult;                    // Color out
  return 1;                                      // Success
  }

//=======================================================================//
_CLASSDEF(TMyColorRect)                 // Class derived from a static
class TMyColorRect : public TStatic     // control to display a colored
  {                                     // rectangle on the screen
  public:                               // This is the hard way to change
                                        // The color of a control
                                        // by overriding WMPaint
                                        // The easy way is to use
                                        // WM_CTLCOLOR
    TMyColorRect(PTWindowsObject AParent, int AnId,  // constructor
		 int X,int Y,int W,int H,
		 LPSTR ATitle, WORD ATextLen,
		 PTModule AModule);
    ~TMyColorRect();                                 // destructor
    virtual void ChangeRectColor(DWORD dwNewColor);  // Changes the color
  protected:
    HBRUSH hBrush;                       // brush used to paint background
    DWORD dwRectColor;                   // current color of Rectangle
    virtual void WMPaint(RTMessage Msg); // traps paint message
  };
// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
TMyColorRect::TMyColorRect(PTWindowsObject AParent, int AnId,
			   int X, int Y, int W, int H,
			   LPSTR ATitle = "Rect", WORD ATextLen = 4,
			   PTModule AModule = NULL)
	    :TStatic(AParent, AnId, ATitle, X,Y,W,H, ATextLen, AModule)
  {
  dwRectColor = RGB(0,0,255);            // initialize Rectangle to Blue
  }
TMyColorRect::~TMyColorRect()            // destructor destroys the brush
  {
  if (hBrush) DeleteObject(hBrush);
  }
void TMyColorRect::ChangeRectColor(DWORD dwNewColor) // changes color
  {
  dwRectColor = dwNewColor;              // update the color variable
  InvalidateRect(HWindow,NULL,TRUE);     // repaint the whole screen
  }
void TMyColorRect::WMPaint(RTMessage Msg) // intercept WM_Paint message
  {
  TStatic::WMPaint(Msg);                  // pass along to base class
  HDC hDC = GetDC(HWindow);               // grab the Device Context
  if (hBrush) DeleteObject(hBrush);       // destroy old brush
  hBrush = CreateSolidBrush(dwRectColor); // create new one using color
  SelectObject(hDC,hBrush);               // select it into the DC
  Rectangle(hDC,0,0,Attr.W,Attr.H);       // use it to draw a rectangle
  ReleaseDC(HWindow,hDC);                 // release the Device Context
  }
//=======================================================================//
_CLASSDEF(TMainDialog)                   // Class derived from a dialog
class TMainDialog : public TDialog       // to add menu and button
  {					 // processing to a main dialog
  public:
    PTMyColorRect pBigRect;              // Pointer for Color Rectangle
    DWORD dwNewColor;                    // New Rectangle Color variable
    TMainDialog(LPSTR lpName);		 // constructor
    virtual void HandleMenuItem(RTMessage Msg)      // menu handler
      = [CM_FIRST + IDM_COLOR];
    virtual void HandleButtonMessage(RTMessage Msg) // button handler
      = [ID_FIRST + IDB_COLOR];          // Note: the exit button is
  };                                     // handled by the base class
// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
TMainDialog::TMainDialog(LPSTR lpName)                // constructor
      :TDialog(NULL,lpName) 		              // calls base class
  {
  dwNewColor = RGB(0,0,255);                          // initialize Color
  pBigRect = new TMyColorRect(this,ID_RECT,22,14,330,120); // and rectangle
  }
void TMainDialog:: HandleMenuItem(RTMessage)          // menu item activates
  {                                                   // non-modal common
  GetApplication()->MakeWindow(new TColorDialog(this,
			       &dwNewColor,
			       "Main_Window_Dialog"));
  pBigRect->ChangeRectColor(dwNewColor);              // change rect color
  }
void TMainDialog:: HandleButtonMessage(RTMessage)     // button activates
  {                                                   // modal common
  GetApplication()->ExecDialog(new TColorDialog(this, // dialog box
		    &dwNewColor,                      // in/out Color
		    "Main_Window_Dialog"));           // any dialog in .RC
  pBigRect->ChangeRectColor(dwNewColor);              // change rect color
  }
//=======================================================================//
class TStandardApp : public TApplication  // Application Class to contain
  {                                      // the application
  public:
    TStandardApp(LPSTR lpName, HANDLE hInstance, // constructor calls the
		HANDLE hPrevInstance,            // base class constructor
		LPSTR lpCmdLine, int nCmdShow)
		:TApplication(lpName, hInstance,
			      hPrevInstance,
			      lpCmdLine, nCmdShow) {};

    virtual void InitMainWindow(); // overrides base class InitMainWindow
  };
// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - //
void TStandardApp::InitMainWindow() // to initialize a dialog box
  {                                 // as the main window
  MainWindow = new TMainDialog("Main_Window_Dialog");
  }
/*************************************************************************/
int PASCAL WinMain(HANDLE hInstance,              // main entry point from
		   HANDLE hPrevInstance,          // windows to this program
		   LPSTR lpCmdLine , int nCmdShow)
  {
  TStandardApp Dialog5("Dialog Tester",hInstance,  // create instance of
		       hPrevInstance,             // the dialog application
		       lpCmdLine,nCmdShow);
  Dialog5.Run();                                  // run it
  return (Dialog5.Status);                        // exit
  }
/*************************************************************************/
//   Remember to use IMPLIB on COMDLG.DLL to create an import library    //
//       And then include the COMMDLG.LIB in the Project Window          //
/*************************************************************************/