/************************************************************************/ 
/*                                                                      */ 
/*								FOS_TEST.C								*/ 
/*									  									*/ 
/*		This is just a conglomeration of C code that I used to test		*/ 
/*	   the FOSSIL interface. It is a super-kludge of misc functions		*/ 
/*		which do all sorts of things, some of which may actually be		*/ 
/*				  useful to someone (who, I don't know!)				*/ 
/*																		*/
/*  BRIEF Tab setting is 4 9 13 (Don't ask why, I screwed up my system)	*/
/*																		*/
/************************************************************************/ 

#include	<stdarg.h>
#include	<stdio.h>
#include	<time.h>
#include	"fossil.h"

#define		RETRY		-1
#define		IGNORE		-2
#define		ABORT		-3
#define		NORETRY		-4
#define		TIMEOUT		-5

struct	_resultcodes	{
		char *	string;
		int		returncode;
		int		baudrate;
}	result[] = {
				"CONNECT FAST",		192,		19200,
				"CONNECT 9600",		96,			9600,
				"CONNECT 4800",		48,			4800,
				"CONNECT 2400",		24,			2400,
				"CONNECT 1200",		12,			1200,
				"CONNECT 600",		6,			600,
				"CONNECT ",			3,			300,
				"RING",				IGNORE,		0,
				"RRING",			IGNORE,		0,
				"BUSY",				RETRY,		0,
				"NO CARRIER",		RETRY,		0,
				"NO DIALTONE",		ABORT,		0,
				"VOICE",			NORETRY,	0,
				"OK",				IGNORE,		0,
				"ERROR",			RETRY,		0,

				NULL,				ABORT,		0
};


char		txbuf[] =
"This is a simple test of FOSSIL's ability to send a large block of characters \
using the block write command of a draft 5 FOSSIL. Hopefully, It will work well \
because that function is helpful during block oriented protocols.";

int		echo_on	= 0;
int		local_on= 0;
int		baud_rate_locked= 1;
char		d_prefix[80] = "AT DT";
char		d_suffix[80] = "\n";
long		timers[10] = {0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L };

/************************************************************************/ 
/*                                                                      */ 
/*		APPARANTLY, THE TIMER TICK STEALING EITHER DOES NOT WORK IN		*/ 
/*		 MSC 5 DUE TO OPTIMIZATION, OR THE FOSSIL I AM TESTING ON		*/ 
/*	   HAS A BUG, OR MY CODE HAS A BUG. I CAN NOT SEEM TO LOCATE IT		*/ 
/*		   SO IF ANY OF YOU PEOPLE FIND IT, PLEASE LET ME KNOW!			*/ 
/*																		*/ 
/************************************************************************/ 

#pragma	check_stack(off)

static int	counter	= 0;

 far
tick_tock()
{
	int far * i;

	i=&counter;
	(*i)++;
}

#pragma	check_stack()

/************************************************************************/ 
/*                                                                      */ 
/*		The f_printf() function works as advertised, but be wary of		*/ 
/*	   using \b's, etc. It may not give you exactly what you wanted		*/ 
/*																		*/ 
/************************************************************************/ 

f_printf(port,string,...)
 int	port;
 char *	string;
{
	char	buffer[128];
	char *	str;

	va_list	arg;
	va_start(arg,string);
	vsprintf(buffer,string,arg);
	va_end(arg);
	
	str = buffer;
	while (*str) {
		f_tx(port,*str);
		if (*str == '\n')
			f_tx(port,13);
		str++;
	}
}

/************************************************************************/ 
/*                                                                      */ 
/*	   This function sends 30,000 bytes to the transmitter, filling		*/ 
/*		   the buffer (note the f_txnowait call) then returning.		*/ 
/*			I use this function for testing the purge and flush			*/ 
/*						 functions of the FOSSIL.						*/ 
/*																		*/ 
/************************************************************************/ 

txtest(port)
 int	port;
{
	int		q;
	int		c='A';

	for (q=0;q<30000;q++) {
		c++;
		if (c > 'Z')
			c = 'A';
		f_txnowait(port,c);
	}
}

/************************************************************************/ 
/*                                                                      */ 
/*		This function simply prints the return from the timer tick		*/ 
/*		 diagnostic functions in the FOSSIL. On an IBM, the values		*/ 
/*						 should be 8, 18, and 55.						*/ 
/*																		*/ 
/************************************************************************/ 

tticktest()
{
	printf("Timer tick values:\n\n");
	printf(" --- Interrupt on vector 0x%02x\n",f_ttint());
	printf(" --- Ticks per second = %u\n",f_ttspeed());
	printf(" --- Milliseconds per tick = %u\n",f_ttmilli());
}

/************************************************************************/ 
/*                                                                      */ 
/*		This tests the flush function. There should be a noticable		*/ 
/*			   delay between the beep and the word FLUSHED.				*/ 
/*																		*/ 
/************************************************************************/ 

flushtest(port)
 int	port;
{
	txtest(port);
	printf("FLUSHING ....\a");
	f_outflush(port);
	printf("FLUSHED\n");
}

/************************************************************************/ 
/*                                                                      */ 
/*		This tests purging, there should not be a delay between the		*/ 
/*						 beep and the word PURGED.						*/ 
/*																		*/ 
/************************************************************************/ 

purgetest(port)
 int	port;
{
	txtest(port);
	printf("PURGING ....\a");
	f_outpurge(port);
	printf("PURGED\n");
}

/************************************************************************/ 
/*                                                                      */ 
/*				   This displays the FOSSIL status word					*/ 
/*																		*/ 
/************************************************************************/ 

status(port)
 int	port;
{
	unsigned int	stat;
	
	stat = f_stat(port);
	f_printf(port,"Status word reads as 0x%04x\n",stat);
}

/************************************************************************/ 
/*                                                                      */ 
/*		  This function prints some stuff, then asks the user to		*/ 
/*				   press the space bar on the terminal.					*/ 
/*																		*/ 
/************************************************************************/ 

txrxtest(port)
 int	port;
{
	unsigned int	space;

	f_printf(port,"Hello, world!\n");
	f_printf(port,"Press the SPACE BAR here now!\n\n");
	space = f_rx(port);
	if (space == ' ')
		f_printf(port,"\nGood!\n");
	else
		f_printf(port,"I received a \'%c\' character (0x%04x)\n",space,space);
}

/************************************************************************/ 
/*                                                                      */ 
/*		This function does a gets() type function, but will timeout		*/ 
/*							if timer 0 alarms.							*/ 
/*																		*/ 
/************************************************************************/ 

f_gets(port,buffer)
 int	port;
 char *	buffer;
{
	int		character;
	
	*buffer = 0;

	while (!expired(0)) {
		character = f_peek(port);
		if (character != 0xffff) {
			character = f_rx(port);
			character &= 0x00ff;
			*buffer++ = character;
			*buffer = 0;
			if (echo_on) {
				f_txnowait(port,character);
				if (character == 13)
					f_txnowait(port,10);
			}
			if (local_on) {
				f_wransi(character);
				if (character == 13)
					f_wransi(10);
			}
			if (character == 13)
				return;
		}
	}
	return;
}

/************************************************************************/ 
/*                                                                      */ 
/*							   NON-PORTABLE!							*/ 
/*									  									*/ 
/*		 This function sets a timer to "alarm" (go active) after a		*/ 
/*					   specified number of seconds.						*/ 
/*																		*/ 
/************************************************************************/ 

set_expiration(timer,seconds)
 int	timer;
 int	seconds;
{
	long far *	tick = (long far *) 0x0000046cL;
	long		increment;

	increment = ((long) seconds) * 1821L;
	increment /= 100L;
	increment += 9L;
	timers[timer] = *tick + increment;
}

/************************************************************************/ 
/*                                                                      */ 
/*							   NON-PORTABLE!							*/ 
/*									  									*/ 
/*				This indicates whether a timer has alarmed.				*/ 
/*																		*/ 
/************************************************************************/ 

expired(timer)
 int	timer;
{
	long far *	tick = (long far *) 0x0000046cL;

	return ((timers[timer] > *tick) ? 0 : 1);
}

/************************************************************************/ 
/*                                                                      */ 
/*		 This function looks for a specific string from the FOSSIL		*/ 
/*		 and reacts accordingly. You can use this to set baud rate		*/ 
/*				 based on the inbound string from a modem.				*/ 
/*																		*/ 
/************************************************************************/ 

f_result(port,time)
 int	port;
 int	time;
{
	char	line[128];
	int		q;

	set_expiration(0,time);
	while (!expired(0)) {
		f_gets(port,line);
		if (expired(0))
			return(TIMEOUT);
		q=0;
		while (result[q].string != NULL) {
			if (!strncmp(line,result[q].string,strlen(result[q].string))) {
				if (result[q].returncode != IGNORE) {
					if (!baud_rate_locked && result[q].baudrate != 0)
						f_baud(port,result[q].baudrate);
					return(result[q].returncode);
				}
			}
			q++;
		}
	}
	return (RETRY);
}

/************************************************************************/ 
/*                                                                      */ 
/*		  This function prints EVERYTHING that you wanted to know		*/ 
/*				   about the FOSSIL you have installed!					*/ 
/*																		*/ 
/************************************************************************/ 

data(port)
 int	port;
{
	struct _fossildata	f;

	f_data(port,sizeof(f),&f);
	printf("FOSSIL Data Structure\n\n");
	printf("size of the structure in bytes      :%d\n",f.strsiz);
	printf("FOSSIL spec driver conforms to      :%d\n",f.majver);
	printf("rev level of this specific driver   :%d\n",f.minver);
	printf("ASCII ID string	                    :%Fs\n",f.ident);
	printf("size of the input buffer (bytes)    :%d\n",f.ibufr);
	printf("number of bytes left in buffer      :%d\n",f.ifree);
	printf("size of the output buffer (bytes)   :%d\n",f.obufr);
	printf("number of bytes left in the buffer  :%d\n",f.ofree);
	printf("width of screen on this adapter     :%d\n",f.swidth);
	printf("height of screen                    :%d\n",f.sheight);
	printf("ACTUAL baud rate, computer to modem :%d\n",f.baud);

}

/************************************************************************/ 
/*                                                                      */ 
/*				 This function tests the writeblk function				*/ 
/*																		*/ 
/************************************************************************/ 

blocktest(port)
 int	port;
{
 	f_printf(port,"Sending %d characters using writeblock\n\n",sizeof(txbuf));
	f_writeblk(port,sizeof(txbuf),txbuf);
	f_outflush(port);
}


/************************************************************************/
/*																		*/ 
/*   Some functions from an old terminal program I once wrote but will	*/
/*                             never claim.								*/
/*																		*/ 
/************************************************************************/ 

setdial(prefix,suffix)
 char *	prefix;
 char *	suffix;
{
	strcpy(d_prefix,prefix);
	strcpy(d_suffix,suffix);
}

 int
dial(port, number)
 int	port;
 char *	number;
{
	int					result;

	f_printf(port,"%s%s%s",d_prefix,number,d_suffix);
	result = f_result(port,30);
	if (result > 0)
		return(0);
	return(result*-1);
}

/************************************************************************/ 
/*																		*/ 
/*						      Good ole main()							*/ 
/*																		*/ 
/************************************************************************/ 

main()
{
	int		port = 0;		/* COM1: */
	int		baud = 2400;	/* 2400	 */

	echo_on	= 1;
	local_on= 1;
	baud_rate_locked= 1;

	f_init(port,0,NULL);
	f_baud(port,baud);
	data(port);
	setdial("AT DT","\n");
	dial(port,"17034948331");
	txtest(port);
	tticktest();
	flushtest(port);
	purgetest(port);
	status(port);
	txrxtest(port);
	blocktest(port);
	f_outflush(port);
	f_deinit(port);
}

