	PAGE	55,132
	NAME	f_functi
	TITLE	FOSSIL Interface Routines for Microsoft C and Turbo C
	SUBTTL	Copyright 1988 Marshall Presnell; All Rights Reserved

;************************************************************************; 
;*									*; 
;*	    Assembled with Microsoft Macro Assembler version 5		*; 
;*	       using MIXED.MAC mixed language macro package.		*; 
;*									*; 
;************************************************************************; 

; NOTE: These functions act... well.... strange. They DO load the proper
;	registers and execute the INT 14 call, but somehow I haven't 
;	figured out why the code doesn't hook the timer tick.....
;
;	Will examine it closer and make a later version available when I
;	figure the problem out. Or if YOU figure it out, send me a copy
;	(and an explanation!)

;========================================================================; 
;=----------------------------------------------------------------------=; 
;=-                                                                    -=; 
;=-	      THIS MODULE HAS BEEN RELEASED FOR USE IN C NEWS	       -=; 
;=-			      					       -=; 
;=-    	ANY QUESTIONS, COMMENTS, OR PROBLEMS SHOULD BE ADDRESSED TO    -=; 
;=-			      					       -=; 
;=-			     MARSHALL PRESNELL			       -=; 
;=-			     13652 LYNN STREET			       -=; 
;=-			   WOODBRIDGE, VA  22191		       -=; 
;=-			      					       -=; 
;=-			FIDONET ADDRESS 109/639.106		       -=; 
;=-								       -=; 
;=----------------------------------------------------------------------=; 
;========================================================================; 

	.8086
	INCLUDE	MIXED.MAC
	SETMODEL

	.CODE

;==========================================================================;
;									   ;
;		SYSTEM EQUATES FOR FOSSIL VERSION 5 INTERFACE		   ;
;									   ;
;==========================================================================;

SETBAUD		EQU	00H
TXCHAR		EQU	01H
RXCHAR		EQU	02H
STATUS		EQU	03H
INIT		EQU	04H
DEINIT		EQU	05H
DTR		EQU	06H
TTICK		EQU	07H
OUTFLUSH	EQU	08H
OUTPURGE	EQU	09H
INPURGE		EQU	0AH
TXNOWAIT	EQU	0BH
PEEK		EQU	0CH
KEYREADNOWAIT	EQU	0DH
KEYREAD		EQU	0EH
FLOWCONTROL	EQU	0FH
CONTROL_C_CHECK	EQU	10H
SETCURS		EQU	11H
GETCURS		EQU	12H
WRANSI		EQU	13H
WATCHDOG	EQU	14H
WRBIOS		EQU	15H
TTICK_FUNCTION	EQU	16H
REBOOT		EQU	17H
READBLOCK	EQU	18H
WRITEBLOCK	EQU	19H
BREAK		EQU	1AH
DATASTRUCTURE	EQU	1BH
INSTALLAPI	EQU	7EH
REMOVEAPI	EQU	7FH

;===========================================================================
;
;	unsigned int f_insertfunc(void (far * func)());
;

HPROC	<f_insertfunc>,<USES DX>,FUNCTION:PTR

	PUSH	ES			;Save ES 
	PUSH	DS			;  ... and DS

	MOV	AX, CS			;Load ES and DS with
	MOV	ES, AX			;the current code segment.
	MOV	DS, AX			;Assuming small model

	MOV	AL, 1			;Load AL with Insert sub-function code
	MOV	AH, TTICK_FUNCTION	;Load AH with main function code
	PLES	DX, FUNCTION		;Load ES:DX with far pointer on stack
	PUSH	ES			;Make it also valid through
	POP	DS			; DS:DX
	INT	14H			;Call FOSSIL

	POP	DS			;Restore DS and 
	POP	ES			;ES to their entry values

	HRET				;Return AX to caller

HENDP	f_insertfunc

;---------------------------------------------------------------------------
;
;	unsigned int f_removefunc(void (far * func)());
;

HPROC	<f_removefunc>,<USES DX>,FUNCTION:PTR

	PUSH	ES			;Save ES 
	PUSH	DS			;  ... and DS

	MOV	AX, CS			;Load ES and DS with
	MOV	ES, AX			;the current code segment.
	MOV	DS, AX			;Assuming small model

	MOV	AL, 0			;Load AL with Remove sub-function code
	MOV	AH, TTICK_FUNCTION	;Load AH with main function code
	PLES	DX, FUNCTION		;Load ES:DX with far pointer on stack
	PUSH	ES			;Make it also valid through
	POP	DS			; DS:DX
	INT	14H			;Call FOSSIL

	POP	DS			;Restore DS and 
	POP	ES			;ES to their entry values

	HRET				;Return AX to caller

HENDP	f_removefunc

	END

