/* 	-------------------------------------------------------------------
	MF Database Header File 
	This API header file is copyrighted 1993 by Carl Brown.
    You may only use this in conjunction with the MF database.
	------------------------------------------------------------------- */

	/*
	Since most people add something like this anyway...
	*/
#ifndef MFHEADER

#define MFHEADER

	/*----------
   	  Structures 
	  ----------*/
   	/* 
   		Used for defining external dll extensions on mfInit  
   	*/
typedef struct {
   int   extType;             /* Type of extension       */
   char  extDLLName[128];     /* Name of DLL extension   */
} tmfExtDLL;
typedef tmfExtDLL FAR * ptmfExtDLL;


   /* 
      Currently supported DLL extensions
   */
#define     EXT_UDK        0     	/* value for a UDK extension DLL 	*/
#define     EXT_UDK_NAME   "mfUDK"	/* Function in the DLL				*/



   /* 
      	Constant variable sizes for prototypes and calls
      
		note:  These MAY change to unsigned longs to support DB's up to
		4GB's (as opposed to 2GB's...)  Try to use these as your parameters
		where they are shown in the API calls...
        
        Also, other OS releases are in the works and 'int' will lose its 
        usefulness.
   */
#define     RPTR        long
#define     IPTR        long

	/*	
		As opposed to the LPSTR, we use FPDATA.  Maybe we should have used a VOID
    	pointer -- but, that's not the case.  It works either way and makes the math
        a little simpler...
    */
#define     FPDATA      char FAR *

	/* 
		Handle to a MF database 
        and MF Task
	*/
#define     hMF_DB      int
#define		hMF_TASK	int

   /* ----------------
      SEEK information
      ---------------- */
#define MFSEEK_BOF      -1
#define MFSEEK_EOF      -2
#define MFSEEK_NODATA   -3

   	/* 
   	iCode (passed integer) RETURN values 
	*/
#define MFSEEK_EXACT_MATCH      1
#define MFSEEK_PARTIAL_MATCH    2


   /* 
   Compare Information (Index sort orders)  
   */
#define MFCOMP_CHAR     1		/* 	Alpha string - case sensitive 				*/
#define MFCOMP_INT      2		/* 	Short Integer or Short Integer array		*/
#define MFCOMP_LONG     3		/*	Long or Long array							*/
#define MFCOMP_CHARIC   4		/* 	Alpha string - case insensitive 			*/
#define MFCOMP_UDK      100   	/* Or greater 									*/


   /* 
      READ/WRITE options
   */
#define MFRW_ALL        -1
#define MFRW_DATA       -2
#define MFRW_KEY        -3
/*
#define MFRW_KEYEXACT   0 // Index # to write for a KEYEXACT (unsupported in this release) 
*/

   /*
       Severe-Performance options
   */
#define MF_SP_COUNT     -1


/*
    ERRORS RETURNED
*/
	/* Open */
    #define mfERR_OPEN_UNDEFINED      -10
    #define mfERR_OPEN_NOHNDLS        -11
    #define mfERR_OPEN_INVALIDFILE    -12
    #define mfERR_OPEN_INVALIDFORMAT  -14
    #define mfERR_OPEN_NO_DBINIFILE   -15
    #define mfERR_OPEN_UDK_NOT_FOUND  -16
    #define mfERR_OPEN_INDEXMISSING	  -17

	/* Close  */
    #define mfERR_CLOSE_BAD           -21

	/* Write  */
    #define mfERR_WRITE_BADRECORD     -31
    #define mfERR_WRITE_NOLOCK        -32

	/* Read  */
    #define mfERR_READ_BADRECORD      -41
    
	/* Append */
    #define mfERR_APPEND_NOADD        -51

	/* Register  */
    #define mfERR_REG_NOTASKS         -61
    #define mfERR_INIT_UDK_NOT_FOUND  -16


	/* CreateDB  */
    #define mfERR_CREATEDB_BADFILE    -71
    #define mfERR_CREATEDB_BADRECSIZE -72


	/* Create Index */
    #define mfERR_CREATEINDEX_BADFILE -81

	/*   Update Index  */
    #define mfERR_UPDINDEX_BADSEQ     -91
    #define mfERR_X_NOOLDKEY          -92
    #define mfERR_X_NOADDKEY          -93

	/* Splits */
    #define mfERR_SPLIT_NOROOM        -101
    
    /* Delete */

    

	/* GENERAL   */
    #define mfERR_EOF                 -2
    #define mfERR_BOF                 -1
      	/*
	 	These usually generate if you haven't been 
	 	verifying your RETURN codes...(They tell you
	 	that you passed a NEGATIVE value as a parameter...)
    	*/
    #define mfERR_BAD_TASKSELECTOR    -220
    #define mfERR_BAD_HNDLSELECTOR    -221
    #define mfERR_BAD_INDEXSELECTOR   -222
    #define mfERR_BAD_EVERYTHING      -223
    
    /* 
    	Global errors (could occur from most calls...)  
    */
    #define mfERR_RECORD_DELETED 	  -300
    

/* 	----------
   	Prototypes
	---------- */
	/* 
   		Data Manipulation 
   	*/

/* KAA - Added so as to support compiling into a C++ file */
#ifdef __cplusplus
extern "C" {
#endif 

#ifdef WIN32
	#define _export	
#endif

int  FAR PASCAL _export mfWrite(RPTR Record, FPDATA dFill, hMF_TASK Task, hMF_DB dbHndl, int Option );
int  FAR PASCAL _export mfRead (RPTR Record, FPDATA dFill, hMF_TASK Task, hMF_DB dbHndl, int Option );
int  FAR PASCAL _export mfDelete(RPTR Record, hMF_TASK Task, hMF_DB dbHndl);
RPTR FAR PASCAL _export mfAppendData(FPDATA dFill, hMF_TASK Task, hMF_DB dbHndl);

   	/* 
   		Movement 
   	*/
RPTR FAR PASCAL _export mfSeek(FPDATA SkStr, int FAR * Code, hMF_TASK Task, hMF_DB dbHndl, int iHndl);
RPTR FAR PASCAL _export mfSkip(RPTR record, long NumSkip, hMF_TASK Task, hMF_DB dbHndl, int idxNumber);
RPTR FAR PASCAL _export mfTop(hMF_TASK Task, hMF_DB dbHndl, int idxNumber);
RPTR FAR PASCAL _export mfBottom(hMF_TASK Task, hMF_DB dbHndl, int idxNumber);

   	/* 
   		Creation 
   	*/
int FAR PASCAL _export mfCreateIndex(LPSTR FileName, int RecSize, int DataType, int NumOfIndexes);
int FAR PASCAL _export mfCreateDB(LPSTR FileName, int dRecSize, int NumIndex, int FAR * iRecSize, int FAR * iType);

   	/* 
   		General stuff  
   	*/
int FAR PASCAL _export mfInfoDB(int FAR * RecSize, int FAR * NumIndexs, RPTR FAR * NumRecs, RPTR FAR * RealRecs, hMF_TASK Task, hMF_DB Hndl);
int FAR PASCAL _export mfInfoIndex(hMF_TASK Task, hMF_DB dbHndl, int iHndl);
int FAR PASCAL _export mfIsDeleted (RPTR Record, hMF_TASK Task, hMF_DB Hndl);
int FAR PASCAL _export mfReIndex(HWND hDisplay, hMF_TASK Task, hMF_DB Hndl);
int FAR PASCAL _export mfLock(RPTR record, hMF_TASK Task, hMF_DB db);
int FAR PASCAL _export mfUnLock(RPTR record, hMF_TASK Task, hMF_DB db);


   	/* 
   		Administrative 
   	*/
hMF_DB 	FAR PASCAL _export mfOpen( LPSTR FileName, hMF_TASK Task);
int 	FAR PASCAL _export mfClose(hMF_TASK Task, hMF_DB dbHndl);
int 	FAR PASCAL _export mfInit( ptmfExtDLL szExtCalls );
int 	FAR PASCAL _export mfDeInit(hMF_TASK Task);


   	/* 
   		Severe-performance functions  
   	*/
long FAR PASCAL _export mfReadList(RPTR record, FPDATA passStr, int FuzzyMatch, RPTR FAR * hitList, long MaxNumHitsWanted, hMF_TASK Task, hMF_DB dbHndl, int iHndl);
                      
/* KAA - Added so as to support compiling into a C++ file */
#ifdef __cplusplus
}
#endif 

#endif	/* MFHEADER */
