/******************************************************************************
   MODULE		:	dlgwnd.h
   Version		:	2.0
   Description	:	The base class for the main window.  This class is
					derived from CDialog and is intended to be used as
					a main window in an application using a dialog
					   as it's main window.  There are also special support
					   classes for CStatusBar (CDlgStatusBar) and CToolBar
					   (CDlgToolBar).
******************************************************************************/

#if !defined(DLGWND_H)

	#define DLGWND_H

	#if !defined(STDAFX_H)
		#error Include stdafx.h before including this file
	#endif

/////////////////////////////////////////////////////////////////////////////
// CDlgStatusBar --
//	This class is a special type of CStatusBar which does not expect
//	a parent frame window to be available.  This allows the statusbar
//	to be used in applications where the main window is a dialog 
//	box.
//
//	NOTE : All the CStatusBar functions have not been tested, but this does let the
//		 ON_UPDATE_COMMAND_UI routing work.

class CDlgStatusBar : public CStatusBar
{
	public:
		CDlgStatusBar() { }
		virtual ~CDlgStatusBar() { }

	protected:
		//{{AFX_MSG(CDlgStatusBar)
		afx_msg LRESULT OnIdleUpdateCmdUI(WPARAM wParam, LPARAM);
		//}}AFX_MSG
		DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
// CDlgToolBar --
//	This class is a special type of CToolBar which does not expect
//	a parent frame window to be available.  This allows the toolbar
//	to be used in applications where the main window is a dialog 
//	box.
//
//	NOTE : All the CToolBar functions have not been tested, but this does let the
//		 ON_UPDATE_COMMAND_UI routing work.

class CDlgToolBar : public CToolBar
{
	public:
		CDlgToolBar() { }
		virtual ~CDlgToolBar() { }

	protected:
		//{{AFX_MSG(CDlgToolBar)
		afx_msg LRESULT OnIdleUpdateCmdUI(WPARAM wParam, LPARAM);
		//}}AFX_MSG
		DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
// CDialogWinApp --
//	This is a generic modeless dialog which can be used as the main 
//	window of an application.
//	It contains :
//		* A status bar and support for an ID_VIEW_STATUS_BAR command.
//		* A tool bar and support for an ID_VIEW_TOOLBAR command.

class CDialogWinApp : public CDialog
{
	public:
		CDialogWinApp();
		virtual ~CDialogWinApp() { }
		
		BOOL CDialogWinApp::Create(UINT nIDTemplate
			, UINT FAR *lpaIDStatus, int cIDStatus
			, UINT FAR *lpaIDToolbar, int cIDToolbar, UINT nIDBitmap
			, CWnd *pParent);

	protected:

		UINT		m_nIDTracking;
		UINT		m_nIDLastMessage;

		UINT FAR	*m_lpaIDStatusBar;
		int			m_cIDStatusBar;
		
		CDlgStatusBar	m_wndStatusBar;

		UINT FAR	*m_lpaIDToolBar;
		int			m_cIDToolBar;
		UINT		m_nIDBitmap;
		
		CDlgToolBar	m_wndToolBar;
	
		//{{AFX_MSG(CDialogWinApp)
		afx_msg void OnViewStatusBar();
		afx_msg void OnUpdateViewStatusBar(CCmdUI* pCmdUI);
		
		afx_msg void OnEnterIdle(UINT nWhy, CWnd *pWho);
		afx_msg LRESULT OnSetMessageString(WPARAM wParam, LPARAM lParam = 0L);
		afx_msg void OnMenuSelect(UINT nItemID, UINT nFlags, HMENU hSysMenu);
		
		afx_msg void OnUpdateKeyIndicator(CCmdUI* pCmdUI);
		afx_msg void OnViewToolbar();
		afx_msg void OnUpdateViewToolbar(CCmdUI* pCmdUI);
		afx_msg void OnSysColorChange();
		afx_msg void OnInitMenuPopup(CMenu *pMenu, UINT, BOOL bSysMenu);
		virtual BOOL OnInitDialog();
		virtual void PostNcDestroy();
		virtual void OnOK();
		virtual void OnCancel();
		//}}AFX_MSG
		DECLARE_MESSAGE_MAP()
};
#endif
