/**************************************************************************
   MODULE		:	MfcDb.cpp
   Version		:	2.0
   Description	:	This is the main code.  It contains the On<Menu> calls
					   as well as all related support function.
**************************************************************************/

#include "stdafx.h"
#include "MfcDb.h"

#ifdef _DEBUG
	#undef THIS_FILE
	static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

static UINT BASED_CODE indicators[] =
{
	ID_SEPARATOR,			// status line indicator
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL
};


static UINT BASED_CODE buttons[] =
{
	ID_FILE_OPEN,
	ID_FILE_SAVE_AS,
	ID_APP_EXIT,
	ID_SEPARATOR,
	ID_HELP_ABOUT 
};

/////////////////////////////////////////////////////////////////////////////
// Message Map -- CMfcDbDlg

BEGIN_MESSAGE_MAP(CMfcDbDlg, CDialogWinApp)
	//{{AFX_MSG_MAP(CMfcDbDlg)
	ON_COMMAND(ID_HELP_ABOUT, OnHelpAbout)
	ON_COMMAND(ID_MFC_CREATE, OnMfcCreate)
	ON_COMMAND(ID_MFC_ADD_10, OnMfcAdd10)
	ON_COMMAND(ID_MFC_SEARCH, OnMfcSearch)
	ON_COMMAND(ID_MFC_READ, OnMfcRead)
	ON_COMMAND(ID_MFC_SEARCH_LIST, OnMfcSearchList)
	ON_COMMAND(ID_MFC2_CREATE, OnMfc2Create)
	ON_COMMAND(ID_MFC2_ADD_10, OnMfc2Add10)
	ON_COMMAND(ID_MFC2_SEARCH, OnMfc2Search)
	ON_COMMAND(ID_MFC2_SEARCH_LIST, OnMfc2SearchList)
	ON_COMMAND(ID_MFC2_READ, OnMfc2Read)
	ON_COMMAND(ID_MFC_ADD_ONE, OnMfcAddOne)
	ON_COMMAND(ID_MFC_DELETE_ONE, OnMfcDeleteOne)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMfcDbDlg::CMfcDbDlg
//	This is the constructor for the CMfcDbDlg class.  It creates a 
//	modeless dialog.

CMfcDbDlg::CMfcDbDlg(CWinApp *pCWndApp, CWnd *pParent) : CDialogWinApp()
{
	ASSERT(pCWndApp != NULL);
	
	m_pCWndApp = pCWndApp;		// save a ptr to the CWinApp for general use
	
	//{{AFX_DATA_INIT(CMfcDbDlg)
	//}}AFX_DATA_INIT

	CDialogWinApp::Create(IDD
		, indicators, sizeof(indicators)/sizeof(UINT)
		, buttons, sizeof(buttons)/sizeof(UINT), IDR_MAIN
		, pParent);
}
	
/////////////////////////////////////////////////////////////////////////////
// CMfcDbDlg::DoDataExchange

void CMfcDbDlg::DoDataExchange(CDataExchange *pDX)
{
	CDialogWinApp::DoDataExchange(pDX);	// call baseclass
	//{{AFX_DATA_MAP(CMfcDbDlg)
	//}}AFX_DATA_MAP
}

/////////////////////////////////////////////////////////////////////////////
// CMfcDbDlg::OnInitDialog
//	OnInitDialog initializes the dialog display.

BOOL CMfcDbDlg::OnInitDialog()
{
	CDialogWinApp::OnInitDialog();	// call baseclass
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CMfcDbDlg::OnOK()
{
	// TODO: Add extra validation here
	
	CDialogWinApp::OnOK();
}

void CMfcDbDlg::OnCancel()
{
	// TODO: Add extra cleanup here
	
	CDialogWinApp::OnCancel();
}

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog

CAboutDlg::CAboutDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CAboutDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	DDX_Control(pDX, ID_PROGRAM_VERSION, m_cProgVersion);
	DDX_Control(pDX, ID_PROGRAM_NAME, m_cProgName);
	DDX_Control(pDX, ID_SYSTEM_RESOURCES, m_cSystemResources);
	DDX_Control(pDX, ID_SYSTEM_MEMORY2, m_cSystemMemory2);
	DDX_Control(pDX, ID_SYSTEM_MEMORY, m_cSystemMemory);
	DDX_Control(pDX, ID_PROGRAM_COPYRIGHT, m_cCopyRight);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg message handlers

void CMfcDbDlg::OnHelpAbout()
{
	CAboutDlg	dlg;
	dlg.DoModal();
}

BOOL CAboutDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
						  
	BOOL fImUsingWin30 = TRUE;
	
	DWORD dwVersion = ::GetVersion();
	
	if ( LOBYTE(LOWORD(dwVersion)) >= 3 && HIBYTE(LOWORD(dwVersion)) > 0 )
		fImUsingWin30 = FALSE;
		
	TRACE("Windows version %d.%d, %d\n", LOBYTE(LOWORD(dwVersion)), HIBYTE(LOWORD(dwVersion)), fImUsingWin30);
	
	m_cProgName.SetWindowText("<Your Application Description>");
	m_cCopyRight.SetWindowText("Copyright \251 <Your Company Name>");
	m_cProgVersion.SetWindowText("1.0.000");
		
	char	szTemp[40];

	DWORD dwTemp = ::GetFreeSpace(0);
	wsprintf(szTemp, "Memory: %lu KB Free", dwTemp/1024);
	m_cSystemMemory.SetWindowText((fImUsingWin30 ? "" : (LPSTR)szTemp));
	m_cSystemMemory2.SetWindowText((fImUsingWin30 ? (LPSTR)szTemp : ""));

	if (fImUsingWin30)
		SetDlgItemText(ID_SYSTEM_RESOURCES, "");
	else
	{
		UINT uiTemp = ::GetFreeSystemResources(GFSR_SYSTEMRESOURCES);
		wsprintf(szTemp, "System Resources: %2i %%", uiTemp);
		m_cSystemResources.SetWindowText(szTemp);
	}
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

CString CMfcDbDlg::ReadFileName()
{
	CString	szFilter;

	TRY
	{
		szFilter.LoadString(IDS_FILTERSTRING_DB);
	}
	CATCH(CMemoryException, e)
	{
		szFilter.Empty();		// delete any allocated memory
		AfxMessageBox(IDS_MEMERROR1, MB_ICONSTOP | MB_OK);
		PostMessage(WM_CLOSE);
		THROW_LAST();
	}
	END_CATCH

	CFileDialog dlg(TRUE, NULL, NULL, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, szFilter);

	if (dlg.DoModal() == IDOK)
		return dlg.GetPathName();
		
	return "";		// Compiler will construct a CString containing this
}


void CMfcDbDlg::OnMfcCreate()
{
	CString	csFileName = ReadFileName();
	
	if (!csFileName.IsEmpty())
	{
		int		iSize[2];
		int		iType[2];
		
		iSize[0] = sizeof(tPersonName);
		iType[0] = MFCOMP_CHAR;
		
		iSize[1] = sizeof(tPersonAge);
		iType[1] = MFCOMP_INT;
		
		CMfDB	*MyDBObject;
		
		if ((MyDBObject = CMfDB::NewDBObject()) != NULL)
		{
			if (MyDBObject->CreateDB(csFileName, sizeof(tPersonRecord), 2, iSize, iType) >= 0)
			{
				TRACE1("Database '%s' created\n", csFileName);
			}
			else
			{
				TRACE1("Database '%s' failed created\n", csFileName);
			}
		}
		else
		{
			TRACE0("NewDBObject failed\n");
		}
			
		delete MyDBObject;
	}
}

void CMfcDbDlg::OnMfcAdd10()
{
	CString	csFileName = ReadFileName();
	
	if (!csFileName.IsEmpty())
	{
		CMfDB	*MyDBObject;
		
		// There are 2 ways to open a database set
#if 1
		// 1st create a DB object
		if ((MyDBObject = CMfDB::NewDBObject()) == NULL)
		{
			TRACE0("NewDBObject() failed\n");
		}
		
		// Then open the DB file(s)
		if (MyDBObject->OpenDB(csFileName) < 0)
		{
			TRACE1("OpenDB('%s') failed\n", csFileName);
		}
		else
		{
#else
		// Create a DB object and open the file(s) at the same time
		if ((MyDBObject = CMfDB::NewDBObject(csFileName)) == NULL)
		{
			TRACE1("NewDBObject('%s') failed\n", csFileName);
		}
		else
		{
#endif
			TRACE1("'%s' successfully accessed\n", csFileName);
		
			tFullRecord		MyRecord;

// if NOSORT is defined then file writes will not update the indexes
//#define NOSORT

			for (int iCount = 0; iCount < 10; iCount++)
			{
				strcpy( MyRecord.tData.tName.szLastName, "Ken");
				strcpy( MyRecord.tNameIndex.szLastName, "Ken");
#ifdef NOSORT
				MyDBObject->AddRecord(MFRW_DATA, (char *)&MyRecord.tData);
#else
				MyDBObject->AddRecord(MFRW_ALL, (char *)&MyRecord);
#endif

				strcpy( MyRecord.tData.tName.szLastName, "Tony");
				strcpy( MyRecord.tNameIndex.szLastName, "Tony");
#ifdef NOSORT
				MyDBObject->AddRecord(MFRW_DATA, (char *)&MyRecord.tData);
#else
				MyDBObject->AddRecord(MFRW_ALL, (char *)&MyRecord);
#endif

				strcpy( MyRecord.tData.tName.szLastName, "Angelo");
				strcpy( MyRecord.tNameIndex.szLastName, "Angelo");
#ifdef NOSORT
				MyDBObject->AddRecord(MFRW_DATA, (char *)&MyRecord.tData);
#else
				MyDBObject->AddRecord(MFRW_ALL, (char *)&MyRecord);
#endif

				strcpy( MyRecord.tData.tName.szLastName, "Sandra");
				strcpy( MyRecord.tNameIndex.szLastName, "Sandra");
#ifdef NOSORT
				MyDBObject->AddRecord(MFRW_DATA, (char *)&MyRecord.tData);
#else
				MyDBObject->AddRecord(MFRW_ALL, (char *)&MyRecord);
#endif

				strcpy( MyRecord.tData.tName.szLastName, "Barbara");
				strcpy( MyRecord.tNameIndex.szLastName, "Barbara");
#ifdef NOSORT
				MyDBObject->AddRecord(MFRW_DATA, (char *)&MyRecord.tData);
#else
				MyDBObject->AddRecord(MFRW_ALL, (char *)&MyRecord);
#endif
			}
		
			TRACE1("40 records written to: %s\n", csFileName);
			
			delete MyDBObject;
		}
	}
}

void CMfcDbDlg::OnMfcSearch()
{
	CString	csFileName = ReadFileName();
	
	if (!csFileName.IsEmpty())
	{
		CMfDB	*MyDBObject;
		
		// There are 2 ways to open a database set, but since I used it above I'm
		//  not going to repeat the example
		
		// Create a DB object and open the file(s) at the same time
		if ((MyDBObject = CMfDB::NewDBObject(csFileName)) == NULL)
		{
			TRACE1("NewDBObject('%s') failed\n", csFileName);
		}
		else
		{

			TRACE1("'%s' successfully accessed\n", csFileName);

			tFullRecord		MyRecord;
			RPTR			lRecordNumber;

			// There are 2 ways to perform a search
#if 0
			// You could just find the match
			if ((lRecordNumber = MyDBObject->Find(strlen("Sandra"), "Sandra")) < 0)
			{
				TRACE0("Find('Sandra') failed\n");
			}
			else
			{
				// and read the record using 2 steps
				MyDBObject->Read(MFRW_ALL, (char *)&MyRecord);
				TRACE2("Data(%d) : %s\n", (int)lRecordNumber, MyRecord.tData.tName.szLastName);
			}
#else
			// or you could find the match, and read the record in one step
			if ((lRecordNumber = MyDBObject->Find(strlen("Sandra"), "Sandra", MFSEEK_PARTIAL_MATCH, MFRW_ALL, (char *)&MyRecord)) < 0)
			{
				TRACE0("Find() failed\n");
			}
			else
			{
				TRACE2("Data(%d) : %s\n", (int)lRecordNumber, MyRecord.tData.tName.szLastName);
			}
#endif
		}
		delete MyDBObject;
	}
}

void CMfcDbDlg::OnMfcSearchList()
{
	CString	csFileName = ReadFileName();
	
	if (!csFileName.IsEmpty())
	{
		CMfDB	*MyDBObject;
		
		// There are 2 ways to open a database set, but since I used it above I'm
		//  not going to repeat the example
		
		// Create a DB object and open the file(s) at the same time
		if ((MyDBObject = CMfDB::NewDBObject(csFileName)) == NULL)
		{
			TRACE1("NewDBObject('%s') failed\n", csFileName);
		}
		else
		{

			TRACE1("'%s' successfully accessed\n", csFileName);

			tFullRecord		MyRecord;
			RPTR			lRecordCount;

			// There are 3 ways to perform a list search
#if 0
			// You could just get the number of matching items
			if ((lRecordCount = MyDBObject->FindAll(strlen("Sandra"), "Sandra", strlen("Sandra"))) < 0)
			{
				TRACE0("Find('Sandra') failed\n");
			}
			else
			{
				TRACE1("Find('Sandra') found %d item(s) in database\n", lRecordCount);
				// and read the matching record(s)
				MyDBObject->Read(MFRW_ALL, (char *)&MyRecord);
				TRACE1("Data : %s\n", MyRecord.tData.tName.szLastName);
			}
#elif 0
			// or you could fill an array with the record numbers which match your search string
			long	MyRecordArray[50];
			if ((lRecordCount = MyDBObject->FindAll(strlen("Sandra"), "Sandra", 1, &MyRecordArray[0], 50)) < 0)
			{
				TRACE0("Find('Sandra') failed\n");
			}
			else
			{
				TRACE1("Array filled %d item(s)\n", lRecordCount);
				
				// This line would read the 1st matching record
				MyDBObject->Read(MFRW_ALL, (char *)&MyRecord);
				TRACE1("Data : %s\n", MyRecord.tData.tName.szLastName);
				
				// or scan/read the entire list
				for (int iOffset = 0; lRecordCount > 0; iOffset++, lRecordCount--)
				{
					MyDBObject->Read(MyRecordArray[iOffset], MFRW_ALL, (char *)&MyRecord);
					TRACE2("Data(%d) : %s\n", (int)MyRecordArray[iOffset], MyRecord.tData.tName.szLastName);
				}
			}
#else
			// or you could read a partial array full, then get more and read another full etc...
			long	MyRecordArray[5];
			if ((lRecordCount = MyDBObject->FindAll(strlen("Sandra"), "Sandra", 1, &MyRecordArray[0], 5)) < 0)
			{
				TRACE0("Find('Sandra') failed\n");
			}
			else
			{
				TRACE1("Array filled %d item(s)\n", lRecordCount);
				
				for (int iOffset = 0; lRecordCount > 0; iOffset++, lRecordCount--)
				{
					MyDBObject->Read(MyRecordArray[iOffset], MFRW_ALL, (char *)&MyRecord);
					TRACE2("Data(%d) : %s\n", (int)MyRecordArray[iOffset], MyRecord.tData.tName.szLastName);
				}
					
				// I'm not doing this in a loop as would be proper since I'm just showing examples
				if ((lRecordCount = MyDBObject->FindMore(&MyRecordArray[0], 5)) < 0)
				{
					TRACE0("FindMore() failed\n");
				}
				else
				{
					TRACE1("Array filled %d item(s)\n", lRecordCount);
				
					for (int iOffset = 0; lRecordCount > 0; iOffset++, lRecordCount--)
					{
						MyDBObject->Read(MyRecordArray[iOffset], MFRW_ALL, (char *)&MyRecord);
						TRACE2("Data(%d) : %s\n", (int)MyRecordArray[iOffset], MyRecord.tData.tName.szLastName);
					}
				}
			}
#endif
		}
		delete MyDBObject;
	}
}

void CMfcDbDlg::OnMfcRead()
{
	CString	csFileName = ReadFileName();
	
	if (!csFileName.IsEmpty())
	{
		CMfDB	*MyDBObject;
		
		// There are 2 ways to open a database set, but since I used it above I'm
		//  not going to repeat the example
		
		// Create a DB object and open the file(s) at the same time
		if ((MyDBObject = CMfDB::NewDBObject(csFileName)) == NULL)
		{
			TRACE1("NewDBObject('%s') failed\n", csFileName);
		}
		else
		{

			TRACE1("'%s' successfully accessed\n", csFileName);

			tFullRecord		MyRecord;

#if 0
			// You could just read the currently active record
			MyDBObject->Read(MFRW_ALL, (char *)&MyRecord);
			TRACE2("Data(%d) : %s\n", (int)MyDBObject->GetRecordNumber, MyRecord.tData.tName.szLastName);
#else
			// or you could specify the record to read.
			MyDBObject->Read(1, MFRW_ALL, (char *)&MyRecord);
			TRACE1("Data(1) : %s\n", MyRecord.tData.tName.szLastName);
			
			MyDBObject->Read(2, MFRW_ALL, (char *)&MyRecord);
			TRACE1("Data(2) : %s\n", MyRecord.tData.tName.szLastName);
			
			MyDBObject->Read(3, MFRW_ALL, (char *)&MyRecord);
			TRACE1("Data(3) : %s\n", MyRecord.tData.tName.szLastName);
			
			MyDBObject->Read(4, MFRW_ALL, (char *)&MyRecord);
			TRACE1("Data(4) : %s\n", MyRecord.tData.tName.szLastName);
			
			MyDBObject->Read(5, MFRW_ALL, (char *)&MyRecord);
			TRACE1("Data(5) : %s\n", MyRecord.tData.tName.szLastName);
#endif
		}
		delete MyDBObject;
	}
}


void CMfcDbDlg::OnMfc2Create()
{
	CString	csFileName = ReadFileName();
	
	if (!csFileName.IsEmpty())
	{
		MyTest1		MyClassInst;
	
		// You could encapsulate this entire thing inside your class, but for sake of
		//  example I'll do it here
		int		iSize[2];
		int		iType[2];
		
		iSize[0] = sizeof(tPersonName);
		iType[0] = MFCOMP_CHAR;
		
		iSize[1] = sizeof(tPersonAge);
		iType[1] = MFCOMP_INT;
		
		if (MyClassInst.CreateDB(csFileName, sizeof(tPersonRecord), 2, iSize, iType) >= 0)
		{
			TRACE1("Database '%s' created\n", csFileName);
		}
		else
		{
			TRACE1("Database '%s' failed created\n", csFileName);
		}
	}
}

void CMfcDbDlg::OnMfc2Add10()
{
	CString	csFileName = ReadFileName();
	
	if (!csFileName.IsEmpty())
	{
		MyTest1		MyClassInst;
	
		if (MyClassInst.OpenDB(csFileName) < 0)
		{
			TRACE1("OpenDB('%s') failed\n", csFileName);
		}
		else
		{
			TRACE1("'%s' successfully accessed\n", csFileName);

// if NOSORT is defined then file writes will not update the indexes
//#define NOSORT

			for (int iCount = 0; iCount < 10; iCount++)
			{
				strcpy( MyClassInst.MyRecord.tData.tName.szLastName, "Ken");
				strcpy( MyClassInst.MyRecord.tNameIndex.szLastName, "Ken");
#ifdef NOSORT
				MyClassInst.AddRecord(MFRW_DATA, (char *)&MyClassInst.MyRecord.tData);
#else
				MyClassInst.AddRecord(MFRW_ALL, (char *)&MyClassInst.MyRecord);
#endif

				strcpy( MyClassInst.MyRecord.tData.tName.szLastName, "Tony");
				strcpy( MyClassInst.MyRecord.tNameIndex.szLastName, "Tony");
#ifdef NOSORT
				MyClassInst.AddRecord(MFRW_DATA, (char *)&MyClassInst.MyRecord.tData);
#else
				MyClassInst.AddRecord(MFRW_ALL, (char *)&MyClassInst.MyRecord);
#endif

				strcpy( MyClassInst.MyRecord.tData.tName.szLastName, "Angelo");
				strcpy( MyClassInst.MyRecord.tNameIndex.szLastName, "Angelo");
#ifdef NOSORT
				MyClassInst.AddRecord(MFRW_DATA, (char *)&MyClassInst.MyRecord.tData);
#else
				MyClassInst.AddRecord(MFRW_ALL, (char *)&MyClassInst.MyRecord);
#endif

				strcpy( MyClassInst.MyRecord.tData.tName.szLastName, "Sandra");
				strcpy( MyClassInst.MyRecord.tNameIndex.szLastName, "Sandra");
#ifdef NOSORT
				MyClassInst.AddRecord(MFRW_DATA, (char *)&MyClassInst.MyRecord.tData);
#else
				MyClassInst.AddRecord(MFRW_ALL, (char *)&MyClassInst.MyRecord);
#endif

				strcpy( MyClassInst.MyRecord.tData.tName.szLastName, "Barbara");
				strcpy( MyClassInst.MyRecord.tNameIndex.szLastName, "Barbara");
#ifdef NOSORT
				MyClassInst.AddRecord(MFRW_DATA, (char *)&MyClassInst.MyRecord.tData);
#else
				MyClassInst.AddRecord(MFRW_ALL, (char *)&MyClassInst.MyRecord);
#endif
			}
			TRACE1("40 records written to: %s\n", csFileName);
		}
	}
}

void CMfcDbDlg::OnMfc2Search()
{
	CString	csFileName = ReadFileName();
	
	if (!csFileName.IsEmpty())
	{
		MyTest1		MyClassInst;
	
		if (MyClassInst.OpenDB(csFileName) < 0)
		{
			TRACE1("OpenDB('%s') failed\n", csFileName);
		}
		else
		{
			TRACE1("'%s' successfully accessed\n", csFileName);
			
			RPTR	lRecordNumber;

			// There are 2 ways to perform a search
			
			// Normally you would encapsulate the data, but for this example 
			//  I just made it public.
#if 0
			// You could just find the match
			if ((lRecordNumber = MyClassInst.Find(strlen("Sandra"), "Sandra")) < 0)
			{
				TRACE0("Find('Sandra') failed\n");
			}
			else
			{
				// and read the record using 2 steps
				MyClassInst.Read(MFRW_ALL);
				TRACE2("Data(%d) : %s\n", (int)lRecordNumber, MyClassInst.MyRecord.tData.tName.szLastName);
			}
#else
			// or you could find the match, and read the record in one step
			if ((lRecordNumber = MyClassInst.Find(strlen("Sandra"), "Sandra", MFSEEK_PARTIAL_MATCH, MFRW_ALL)) < 0)
			{
				TRACE0("Find() failed\n");
			}
			else
			{
				TRACE2("Data(%d) : %s\n", (int)lRecordNumber, MyClassInst.MyRecord.tData.tName.szLastName);
			}
#endif
		}
	}
}

void CMfcDbDlg::OnMfc2SearchList()
{
	CString	csFileName = ReadFileName();
	
	if (!csFileName.IsEmpty())
	{
		MyTest1		MyClassInst;
	
		if (MyClassInst.OpenDB(csFileName) < 0)
		{
			TRACE1("OpenDB('%s') failed\n", csFileName);
		}
		else
		{
			TRACE1("'%s' successfully accessed\n", csFileName);
			
			RPTR	lRecordCount;

			// There are 3 ways to perform a list search
#if 0
			// You could just get the number of matching items
			if ((lRecordCount = MyClassInst.FindAll(strlen("Sandra"), "Sandra", strlen("Sandra"))) < 0)
			{
				TRACE0("Find('Sandra') failed\n");
			}
			else
			{
				TRACE1("Find('Sandra') found %d item(s) in database\n", lRecordCount);
				// and read the matching record(s)
				MyClassInst.Read(MFRW_ALL);
				TRACE1("Data : %s\n", MyClassInst.MyRecord.tData.tName.szLastName);
			}
#elif 0
			// or you could fill an array with the record numbers which match your search string
			long	MyRecordArray[50];
			if ((lRecordCount = MyClassInst.FindAll(strlen("Sandra"), "Sandra", 1, &MyRecordArray[0], 50)) < 0)
			{
				TRACE0("Find('Sandra') failed\n");
			}
			else
			{
				TRACE1("Array filled %d item(s)\n", lRecordCount);
				
				// This line would read the 1st matching record
				MyClassInst.Read(MFRW_ALL);
				TRACE2("Data(%d) : %s\n", (int)MyClassInst.GetRecordNumber, MyClassInst.MyRecord.tData.tName.szLastName);
				
				// or scan/read the entire list
				for (int iOffset = 0; lRecordCount > 0; iOffset++, lRecordCount--)
				{
					MyClassInst.Read(MyRecordArray[iOffset], MFRW_ALL);
					TRACE2("Data(%d) : %s\n", (int)MyRecordArray[iOffset], MyClassInst.MyRecord.tData.tName.szLastName);
				}
			}
#else
			// or you could read a partial array full, then get more and read another full etc...
			long	MyRecordArray[5];
			if ((lRecordCount = MyClassInst.FindAll(strlen("Sandra"), "Sandra", 1, &MyRecordArray[0], 5)) < 0)
			{
				TRACE0("Find('Sandra') failed\n");
			}
			else
			{
				TRACE1("Array filled %d item(s)\n", lRecordCount);
				
				for (int iOffset = 0; lRecordCount > 0; iOffset++, lRecordCount--)
				{
					MyClassInst.Read(MyRecordArray[iOffset], MFRW_ALL);
					TRACE2("Data(%d) : %s\n", (int)MyRecordArray[iOffset], MyClassInst.MyRecord.tData.tName.szLastName);
				}
					
				// I'm not doing this in a loop as would be proper since I'm just showing examples
				if ((lRecordCount = MyClassInst.FindMore(&MyRecordArray[0], 5)) < 0)
				{
					TRACE0("FindMore() failed\n");
				}
				else
				{
					TRACE1("Array filled %d item(s)\n", lRecordCount);
				
					for (int iOffset = 0; lRecordCount > 0; iOffset++, lRecordCount--)
					{
						MyClassInst.Read(MyRecordArray[iOffset], MFRW_ALL);
						TRACE2("Data(%d) : %s\n", (int)MyRecordArray[iOffset], MyClassInst.MyRecord.tData.tName.szLastName);
					}
				}
			}
#endif
		}
	}
}

void CMfcDbDlg::OnMfc2Read()
{
	CString	csFileName = ReadFileName();
	
	if (!csFileName.IsEmpty())
	{
		MyTest1		MyClassInst;
	
		if (!MyClassInst.GetValid())
		{
			TRACE0("Derived Class was not constructed properly\n");
			return;
		}
		
		if (MyClassInst.OpenDB(csFileName) < 0)
		{
			TRACE1("OpenDB('%s') failed\n", csFileName);
		}
		else
		{
			TRACE1("'%s' successfully accessed\n", csFileName);
#if 0
			// You could just read the currently active record
			MyClassInst.Read(MFRW_ALL);
			TRACE2("Data(%d) : %s\n", (int)MyClassInst.GetRecordNumber, MyClassInst.MyRecord.tData.tName.szLastName);
#else
			// or you could specify the record to read.
			MyClassInst.Read(1, MFRW_ALL);
			TRACE1("Data(1) : %s\n", MyClassInst.MyRecord.tData.tName.szLastName);
			
			MyClassInst.Read(2, MFRW_ALL);
			TRACE1("Data(2) : %s\n", MyClassInst.MyRecord.tData.tName.szLastName);
			
			MyClassInst.Read(3, MFRW_ALL);
			TRACE1("Data(3) : %s\n", MyClassInst.MyRecord.tData.tName.szLastName);
			
			MyClassInst.Read(4, MFRW_ALL);
			TRACE1("Data(4) : %s\n", MyClassInst.MyRecord.tData.tName.szLastName);
			
			MyClassInst.Read(5, MFRW_ALL);
			TRACE1("Data(5) : %s\n", MyClassInst.MyRecord.tData.tName.szLastName);
#endif
		}
	}
}

void CMfcDbDlg::OnMfcAddOne()
{
	CString	csFileName = ReadFileName();
	
	if (!csFileName.IsEmpty())
	{
		CMfDB	*MyDBObject;
		
		// There are 2 ways to open a database set
#if 1
		// 1st create a DB object
		if ((MyDBObject = CMfDB::NewDBObject()) == NULL)
		{
			TRACE0("NewDBObject() failed\n");
		}
		
		// Then open the DB file(s)
		if (MyDBObject->OpenDB(csFileName) < 0)
		{
			TRACE1("OpenDB('%s') failed\n", csFileName);
		}
		else
		{
#else
		// Create a DB object and open the file(s) at the same time
		if ((MyDBObject = CMfDB::NewDBObject(csFileName)) == NULL)
		{
			TRACE1("NewDBObject('%s') failed\n", csFileName);
		}
		else
		{
#endif
			TRACE1("'%s' successfully accessed\n", csFileName);
		
			tFullRecord		MyRecord;

// if NOSORT is defined then file writes will not update the indexes
//#define NOSORT

			strcpy( MyRecord.tData.tName.szLastName, "Ken");
			strcpy( MyRecord.tNameIndex.szLastName, "Ken");
#ifdef NOSORT
			MyDBObject->AddRecord(MFRW_DATA, (char *)&MyRecord.tData);
#else
			MyDBObject->AddRecord(MFRW_ALL, (char *)&MyRecord);
#endif

		
			TRACE1("1 record written to: %s\n", csFileName);
			
			delete MyDBObject;
		}
	}
}

void CMfcDbDlg::OnMfcDeleteOne()
{
	CString	csFileName = ReadFileName();
	
	if (!csFileName.IsEmpty())
	{
		CMfDB	*MyDBObject;
		
		// There are 2 ways to open a database set
#if 1
		// 1st create a DB object
		if ((MyDBObject = CMfDB::NewDBObject()) == NULL)
		{
			TRACE0("NewDBObject() failed\n");
		}
		
		// Then open the DB file(s)
		if (MyDBObject->OpenDB(csFileName) < 0)
		{
			TRACE1("OpenDB('%s') failed\n", csFileName);
		}
		else
		{
#else
		// Create a DB object and open the file(s) at the same time
		if ((MyDBObject = CMfDB::NewDBObject(csFileName)) == NULL)
		{
			TRACE1("NewDBObject('%s') failed\n", csFileName);
		}
		else
		{
#endif
			TRACE1("'%s' successfully accessed\n", csFileName);
			
			if (MyDBObject->GetLast() >= 0)
			{
				MyDBObject->DeleteRecord();
				TRACE0("Record deleted \n");
			}
			else
			{
				TRACE0("Record NOT deleted \n");
			}
		}
		delete MyDBObject;
	}
}
