/**************************************************************************
   MODULE		:	mainwnd.cpp
   Version		:	2.0
   Description	:	This file contains the override for CWinApp
**************************************************************************/

#include "stdafx.h"
#include "mainwnd.h"
#include "MfcDb.h"	// for CMfcDbDlg definition

#ifdef _DEBUG
	#undef THIS_FILE
	static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// This is the one and only CMfcDbApp object.

CMfcDbApp NEAR app;

/////////////////////////////////////////////////////////////////////////////
// Message Map -- CMfcDbApp

BEGIN_MESSAGE_MAP(CMfcDbApp, CWinApp)
	//{{AFX_MSG_MAP(CMfcDbApp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMfcDbApp::CMfcDbApp

CMfcDbApp::CMfcDbApp()
{	  
}

/////////////////////////////////////////////////////////////////////////////
// CMfcDbApp::ExitInstance
//	ExitInstance is called by the application framework to exit an
//	instance of the MfcDb application.  It performs all clean up 
//	required by the application.

int CMfcDbApp::ExitInstance()
{
	Ctl3dUnregister(AfxGetInstanceHandle());
	return CWinApp::ExitInstance();
}

/////////////////////////////////////////////////////////////////////////////
// CMfcDbApp::InitApplication
//	InitApplication performs per-application initialization of the 
//	MfcDb application.  It registers a private window class for
//	the main application dialog.  By doing this, and by specifying the 
//	class name in the dialog template, we can associate an icon with 
//	the dialog.

BOOL CMfcDbApp::InitApplication()
{
	BOOL		bSuccess;
	WNDCLASS	wc;

	// Get normal dialog class information
	bSuccess = GetClassInfo(NULL, MAKEINTRESOURCE(0x8002), &wc);
   
	if (bSuccess)
	{
		// modify normal dialog class info to suit our needs
		wc.lpszClassName = "MfcDb";
		wc.style ^= CS_GLOBALCLASS;
		wc.hIcon = LoadIcon(IDR_MAIN);
		wc.hInstance = AfxGetInstanceHandle();
		bSuccess = (::RegisterClass(&wc) != 0) ? TRUE : FALSE;
	}
	return bSuccess;
}

/////////////////////////////////////////////////////////////////////////////
// CMfcDbApp::InitInstance
//	InitInstance performs per-instance initialization of the MfcDb
//	application.
//	If an instance of the application is already running, it activates
//	that instance.  Otherwise, it creates the modeless dialog which
//	serves as the application's interface.
//

BOOL CMfcDbApp::InitInstance()
{
	BOOL bSuccess = FALSE;

	CWnd *pwndFirst = CWnd::FindWindow("MfcDb", NULL);
   
	if (pwndFirst)
	{
		// another instance is already running -- activate it
		CWnd *pwndChild = pwndFirst->GetLastActivePopup();
		pwndFirst->BringWindowToTop();
		if (pwndFirst != pwndChild)
			pwndChild->BringWindowToTop();
		if (pwndFirst->IsIconic())
			pwndFirst->ShowWindow(SW_SHOWNORMAL);
	}
	else
	{
		// this is the first instance -- create the dialog
		Ctl3dRegister(AfxGetInstanceHandle());
		Ctl3dAutoSubclass(AfxGetInstanceHandle());
		
		TRY
		{
			m_pMainWnd = new CMfcDbDlg(this);
			bSuccess = TRUE;
		}
		CATCH_ALL(e)
		{
			bSuccess = FALSE;
		}
		END_CATCH_ALL
			 
		Ctl3dSubclassDlg(m_pMainWnd->m_hWnd, CTL3D_ALL);
		
		m_pMainWnd->Invalidate(TRUE);

	}
	
	return bSuccess;
}
	
/////////////////////////////////////////////////////////////////////////////
// Translate accelerator messages here. We will load the accelerator
//	table the first time the function is called.

BOOL CMfcDbApp::PreTranslateMessage(MSG *pMsg)
{
	static	HACCEL	m_hAccel=NULL;		// Accelerator handle

	if(!m_hAccel)
		m_hAccel=::LoadAccelerators(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDR_MAIN_ACCEL));

	if(!TranslateAccelerator(m_pMainWnd->m_hWnd, m_hAccel, pMsg))
		return CWinApp::PreTranslateMessage(pMsg);
	else
		return TRUE;
}
