/**************************************************************************
   MODULE		:	MfcDb.h
   Version		:	2.0
   Description	:	This is the main code.  It contains the On<Menu> calls
					   as well as all related support function.
**************************************************************************/

#if !defined(MfcDb_H)

	#define MfcDb_H

	#if !defined(STDAFX_H)
		#error Include stdafx.h before including this file
	#endif

	#include "dlgwnd.h"

/////////////////////////////////////////////////////////////////////////////
// CMfcDbDlg --
//	This is the main window for the MfcDb application.  It is a
//	modeless dialog box.

class CMfcDbDlg : public CDialogWinApp
{
	public:
	CMfcDbDlg(CWinApp *pCWndApp, CWnd* pParent = NULL);
	CString ReadFileName();

	protected:
	CWinApp		*m_pCWndApp;
	//{{AFX_DATA(CMfcDbDlg)
	enum { IDD = IDR_MAIN };
	//}}AFX_DATA

	virtual void DoDataExchange(CDataExchange* pDX);

	//{{AFX_MSG(CMfcDbDlg)
	virtual BOOL OnInitDialog();
	virtual void OnCancel();
	virtual void OnOK();
	afx_msg void OnHelpAbout();
	afx_msg void OnMfcCreate();
	afx_msg void OnMfcAdd10();
	afx_msg void OnMfcSearch();
	afx_msg void OnMfcRead();
	afx_msg void OnMfcSearchList();
	afx_msg void OnMfc2Create();
	afx_msg void OnMfc2Add10();
	afx_msg void OnMfc2Search();
	afx_msg void OnMfc2SearchList();
	afx_msg void OnMfc2Read();
	afx_msg void OnMfcAddOne();
	afx_msg void OnMfcDeleteOne();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog

class CAboutDlg : public CDialog
{
// Construction
public:
	CAboutDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUT };
	CStatic	m_cProgVersion;
	CStatic	m_cProgName;
	CStatic	m_cSystemResources;
	CStatic	m_cSystemMemory2;
	CStatic	m_cSystemMemory;
	CStatic	m_cCopyRight;
	//}}AFX_DATA

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(CAboutDlg)
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};



// This is stuff to test the different functions of CMFdb

#include "..\mylib\CMFdb.h"

struct tPersonName
{
	char	szLastName[20];
	char	szFirstName[20];
};
	
struct tPersonAge
{
	int		iAge;
};
	
struct tPersonAddress
{
	char	szStreet[20];
	char	szCity[20];
};
	
struct tPersonRecord
{
	tPersonName		tName;
	tPersonAge		tAge;
	tPersonAddress	tAddress;
};

struct tFullRecord
{
	tPersonName		tNameIndex;
	tPersonAge		tAgeIndex;
	tPersonRecord	tData;
};

class	MyTest1 : public CMfDB
{
	// Member variables
	// Public so I can get to the data from within the example code
	public:
		tFullRecord	MyRecord;
		
	// Member functions
	public:
		virtual	char *GetDataBuffer() { return (char *)&MyRecord.tData; }
		virtual char *GetIndexBuffer() { return (char *)&MyRecord; }
		virtual char *GetBothBuffers() { return (char *)&MyRecord; }
};

#endif	//!defined(MAINDLG_H)
