#include <stdio.h>
#include <string.h>
#include "cmdparse.h"

main()
{
    int status,i;
    char *cptr;

    printf("Demonstration of CMDPARSE.C - parse command line\n");

    status = cmd_init();                      /* setup */

    if (status == 0)
    {
        printf("\nError on call to cmd_init() - Abort\n\n");
        exit(0);
    }

    printf("\n============== List of Parameters ==================\n\n");

    for (i=0; (cptr = get_param(i)) != NULL; i++)
        printf("Parameter # %d: %s\n",i,cptr);

    printf("\n============== List of All Options ==================\n\n");

    for (i=0; cmd_arg[i] != NULL; i++)
        if (arg_type[i] == 1)
            printf("%s\n",cmd_arg[i]);

    printf("\nPress RETURN to continue");

    getchar();

    printf("\n========= Case-insensitive Option Search ============\n\n");

    printf("Looking for N option     :  ");

    if (if_optioni("n") == 0) printf("NOT ");

    printf("Found\n");

    printf("Looking for INDEX option :  ");

    if (if_optioni("index") == 0) printf("NOT ");

    printf("Found      ");

    if ((cptr = opt_valuei("index")) != NULL)
        printf("Value of INDEX is %s\n",cptr);
    else
        printf("INDEX has no Rvalue (/index=value)\n");

    printf("\n========= GET_PARAM for parameters 1 & 3 ============\n\n");

    cptr = get_param(1);

    if (cptr != NULL)
       printf("First parameter is     %s\n",cptr);

    cptr = get_param(3);

    if (cptr != NULL)
       printf("Third parameter is     %s\n\n",cptr);

    exit(0);
}
