/***************************************************************
File: COMMON.CPP              Copyright 1992 by Dlugosz Software
part of the CMDL package for command-line parsing
common functions for command-line argument derived classes
This version may be used freely, with attribution.
***************************************************************/

#include "usual.h"
#include "cmdl.h"
#include "scanner.h"
#include <string.h>
#include <stdlib.h>

/* /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\ */
/*     post-processing                      */
/* /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\ */

void cmdl::validate (unsigned fl)
{
/* this virtual function is called for each argument after parseing is
   complete.  It can be overriden in a derived class to do addtional tests. */
if ((flags&required) && !(flags&used)) {
   // if required but not present
   if (flags & noname) output ("error:  too few parameters\n");
   else foutput ("error:  parameter @ is required\n");
   exit (1);
   }
}

/* /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\ */
/*     parsing and extracting values        */
/* /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\ */

bool cmdl::prelude()
{
/* called by scan() functions for standard actions in parsing
   a command line argument.   */
if ((flags&once) && (flags&used)) {
   // if `once' flag set, make sure it is in fact only used once.
   error= Duplicate;
   return FALSE;
   }
flags |= used;  //mark as used.
return TRUE;
}

/* /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\ */

char* cmdl::getvalue (cmdlscan& s)
{
/* this gets the associated value that follows a paramter.  At this
   point, it is just a string.  The caller will take the result and
   convert to the proper type and further analyse it.
   Forms are:
    1)    name=value
    2)    name value
    3)    namevalue
    4)    value
    #3 leaves it up the the primary parser (already done)
   how to tell where the name leaves off and the value begins.  It
   works for one-letter names, i.e.  -c10.
    #2 is not allowed if the value is optional, since it could not
   tell if the following token was the next parameter or the argument
   of this one.
    #4 is for positional parameters, where there is no name.  It is
   necessary to distinguish between this and form 1 because the value
   could begin with a '=' character.
*/

if (!(flags & noname)) { //not a positional parameter
   char ch= s.thischar();
   if (ch == '=') ++s;  //skip the '=' character
   else {
      //forms without a '=' character.
      if (flags & valueoptional) {
         //whitespace is considered no value
         if (ch == ' ' || ch == '\t' || ch == '\n' || ch == '\0')
            return 0;
         }
      s.skipws();  //skip any whitespace
      }
   }
char* value= s.extract_string();
return value;
}

/* /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\ */

bool cmdl::matchname (const char* s)
{
/* this decides if `s' matches the name of this object */
if (s[1] == '\0') {
   if (s[0] == cname) return TRUE;
   }
else {
   if (!strcmp (s,sname)) return TRUE;
   }
return FALSE;
}

/* /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\ */

