// command line test program
// John M. Dlugosz


#include "usual.h"
#include "cmdl.h"
#include <stdio.h>

// these can be static globals, spread in several modules even.
typedef cmdl_flag flag;
flag v ('v', "requests verbose mode");
flag s ('s', "specifies alternate algorythm");
flag T ('T', "prevents the foobar from clearing (debugging)"  ,cmdl::once);
cmdl_string name ("name", "name to place on reports (use \"'s around the string)");
cmdl_string file ("file", "file to operate on (required)", cmdl::required);
cmdl_string pos1 ((char*)0, "first positional parameter");
cmdl_int count ('c', "iteration count");

/* /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\ */

int main()
{
cmdl::signon ("stupid test program to test parameter passing.\nWritten by John M. Dlugosz\n");
cmdl::parseit();
// report on what was found
if (v()) puts ("you selected -v");
if (s()) puts ("you selected -s");
if (T()) puts ("you selected -T");
if (name()) printf ("name=\"%s\"\n",name());
if (file()) printf ("file=\"%s\"\n",file());
if (pos1()) printf ("first positional parameter is \"%s\"\n", pos1());
if (count.hasvalue()) printf ("count= %d\n", count());
}
