/***************************************************************
File: INT.CPP                 Copyright 1992 by Dlugosz Software
part of the CMDL package for command-line parsing
cmdl_int class -- integer paramters
This version may be used freely, with attribution.
***************************************************************/

#include "usual.h"
#include "cmdl.h"

/* /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\ */

void cmdl_int::report_error()
{
switch (error) {
   case NoValue:
      foutput ("use:\n@=<number> or @ <number>\n");
      break;
   case BadValue:
      foutput ("number for @ is ill-formed\n");
      break;
   default:
      cmdl::report_error();
   }
}

/* /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\ */

bool cmdl_int::scan (cmdlscan& scan)
{
if (!prelude()) return FALSE;
char* newval= getvalue (scan);
if (!newval) return FALSE;
// instead of using atoi(), use my own code to convert, so I can do
//  proper error checking.
int n= 0;
char* s= newval;
char ch= *s;
bool negflag= FALSE;
if (ch == '-') {
   negflag= TRUE;
   s++;
   }
else if (ch == '+') s++;
while ((ch=*s++) != '\0') {
   if (ch < '0' || ch > '9') {
      error= BadValue;
      return FALSE;
      }
   n= 10*n + (ch-'0');
   }
value= negflag ? -n : n;
delete newval;
return TRUE;
}

/* /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\ */
