/***************************************************************
File: SCANNER.H               Copyright 1992 by Dlugosz Software
part of the CMDL package for command-line parsing
the scanner class, used as part of parsing the strings.
This version may be used freely, with attribution.
***************************************************************/

class cmdlscan {
   const char* source;  //name of where this came from (for error reports)
   cmdlscan* link;      //previous string
   char* s;     //the string being scanned
   int cursor;  //the current scan position
public:
   cmdlscan (char* s);
   int mark() { return cursor; };
   void restore (int x) { cursor= x; };
   void skipws();  //skip whitespace
   void extract_word (char* buf, int len);
   void operator++ () { cursor++; }
   char thischar() { return s[cursor]; }
   char* extract_string();
   };
