// CmSet.cpp
// -----------------------------------------------------------------
// Compendium - C++ Container Class Library
// Copyright (C) 1992-1994, Glenn M. Poorman, All rights reserved
// -----------------------------------------------------------------
// Set implementation.
// -----------------------------------------------------------------

#include <cm/include/cmset.h>


// "CmSet" is the default set constructor.
//
CmSet::CmSet(unsigned sz) : CmHashTable(sz)
{}


// "CmSet" is the set copy constructor.
//
CmSet::CmSet(const CmSet& S) : CmHashTable(S)
{}


// "=" assignment operator copies the contents of the specified set
// into this set.
//
CmSet& CmSet::operator=(const CmSet& S)
{
  return (CmSet&) CmHashTable::operator=(S);
}


// "-" difference operator returns a set containing those objects
// appearing in this set and the input set but not in both sets.
//
CmSet CmSet::operator-(const CmSet& set)
{
  CmSet out;
  out.ownsObjects(FALSE);

  CmHashTableIterator iterator(*this);
  Bool                success = TRUE;
  while (!iterator.done() && success)
  {
    CmObject* pObj = iterator.next();
    if (!set.lookup(pObj)) success = out.add(pObj);
  }

  CmHashTableIterator iterator2(set);
  while (!iterator2.done() && success)
  {
    CmObject* pObj = iterator2.next();
    if (!lookup(pObj)) success = out.add(pObj);
  }
  return out;
}


// "&" intersection operator returns a set containing only those
// objects appearing in this set and the input set.
//
CmSet CmSet::operator&(const CmSet& set)
{
  CmSet out;
  out.ownsObjects(FALSE);

  CmHashTableIterator iterator(*this);
  Bool                success = TRUE;
  while (!iterator.done() && success)
  {
    CmObject *pObj = iterator.next();
    if (set.lookup(pObj)) success = out.add(pObj);
  }
  return out;
}


// "|" union operator returns a set containing those objects
// appearing in this set, the input set, or both sets.
//
CmSet CmSet::operator|(const CmSet& set)
{
  CmSet out;
  out.ownsObjects(FALSE);

  CmHashTableIterator iterator(*this);
  while (!iterator.done()) out.add(iterator.next());

  CmHashTableIterator iterator2(set);
  while (!iterator2.done()) out.add(iterator2.next());
  return out;
}


// "add" adds a new object to the set provided it is not already
// contained in the set.
//
Bool CmSet::add(CmObject* pObj)
{
  return (contains(pObj)) ? FALSE : CmHashTable::add(pObj);
}
