// CmQueue.cpp
// -----------------------------------------------------------------
// Compendium - C++ Container Class Library
// Copyright (C) 1992-1994, Glenn M. Poorman, All rights reserved
// -----------------------------------------------------------------
// Queue implementation.
// -----------------------------------------------------------------

#include <cm/include/cmqueue.h>


// "CmQueue" is the default queue constructor.
//
CmQueue::CmQueue() : CmLinkedList()
{}


// "CmQueue" is the queue copy constructor.
//
CmQueue::CmQueue(const CmQueue& St) : CmLinkedList(St)
{}


// "=" assignment operator copies the specified queue into this queue.
//
CmQueue& CmQueue::operator=(const CmQueue& Qu)
{
  return (CmQueue&) CmLinkedList::operator=(Qu);
}


// "push" places the specified object into the end of the queue.
//
Bool CmQueue::push(CmObject* pObj)
{
  return append(pObj);
}


// "pop" pops the front object out of the queue and returns it.
//
CmObject* CmQueue::pop()
{
  return removeFirst();
}


// "peek" returns a pointer to the front object in the queue leaving the
// object in place.
// 
CmObject* CmQueue::peek() const
{
  return first();
}
