// CmObject.cpp
// -----------------------------------------------------------------
// Compendium - C++ Container Class Library
// Copyright (C) 1992-1994, Glenn M. Poorman, All rights reserved
// -----------------------------------------------------------------
// Abstract object implementation.
// -----------------------------------------------------------------

#include <cm/include/cmobject.h>
#include <cm/include/cmobjref.h>
#include <cm/include/cmreserv.h>


// Shorthand definitions.
#define OBJ CmObjectReference::OBJECTS
#define KEY CmObjectReference::KEYS


// "writeObject" writes this object to the specified reserve file.
//
Bool CmObject::writeObject(CmReserveFile& file)
{
  if (!file.write(this->isA())) return FALSE;  // Write class name.

  int key, flag = CmReserve::OBJECT;
  if (CmReserve::maintainReferences())
  {
    key  = CmReserve::getFromTable(this);      // See if object is in table.
    flag = (key >= 0) ? CmReserve::REFERENCE : CmReserve::OBJECT;
  }
  Bool success = file.write(flag);             // Write reference flag.

  if (success && flag == CmReserve::REFERENCE) // If object was written.
    success = file.write(key);                 // Write table key.
  else if (success)                            // Object was not written.
  {
    success = this->write(file);               // Write object.
    if (CmReserve::maintainReferences() && success)
      success = CmReserve::addToTable(this, OBJ);
  }
  return success;
}


// "readObject" reads an object from the specified reserve file.
//
CmObject* CmObject::readObject(CmReserveFile& file)
{
  char *letters = file.read();                 // Read class name.
  if (!letters) return NULL;

  int flag;
  if (!file.read(flag))                        // Read reference flag.
  {
    delete[] letters;
    return NULL;
  }

  CmObject *pObj = NULL;
  if (flag == CmReserve::REFERENCE)            // If object was reference,
  {
    int key;
    if (file.read(key))                        // Read table index.
      pObj = CmReserve::getFromTable(key);     // Get pointer from table.
  }
  else
  {
    CmObject *temp = CmReserve::getClassRegister(letters); // Get register.
    if (temp)
    {
      pObj = temp->newCopy();                  // Clone register.
      if (pObj)
      {
        Bool success = pObj->read(file);       // Read object data.
        if (!success)
        {
          delete pObj;
          pObj = NULL;
        }
        else
          CmReserve::addToTable(pObj, KEY);    // Add to reference table.
      }
    }
  }
  delete[] letters;
  return pObj;                                 // Return new object.
}
