// CmIter.cpp
// -----------------------------------------------------------------
// Compendium - C++ Container Class Library
// Copyright (C) 1992-1994, Glenn M. Poorman, All rights reserved
// -----------------------------------------------------------------
// Abstract container iterator implementation.
// -----------------------------------------------------------------

#include <cm/include/cmiter.h>

// "nextOccurence" advances the iterator to the next occurrence of
// the specified object.
//
CmObject* CmIterator::nextOccurrence(CmObject* pObj)
{
  while (!done() && !(current()->isEqual(pObj))) next();
  CmObject *out = (done()) ? NULL : current(); next();
  if (out)
    while (!done() && !(current()->isEqual(out)))
      next();
  return out;
}


// "previousOccurence" advances the iterator to the previous occurrence of
// the specified object.
//
CmObject* CmIterator::previousOccurrence(CmObject* pObj)
{
  while (!done() && !(current()->isEqual(pObj))) previous();
  CmObject *out = (done()) ? NULL : current(); previous();
  if (out)
    while (!done() && !(current()->isEqual(out)))
      previous();
  return out;
}


// "+=" advances the iterator n places and returns the object.
//
CmObject* CmIterator::operator+=(int num)
{
  for (int ii = 0; ii < num; ii++) next();
  return current();
}


// "-=" decrements the iterator n places and returns the object.
//
CmObject* CmIterator::operator-=(int num)
{
  for (int ii = 0; ii < num; ii++) previous();
  return current();
}
