// CmDeque.cpp
// -----------------------------------------------------------------
// Compendium - C++ Container Class Library
// Copyright (C) 1992-1994, Glenn M. Poorman, All rights reserved
// -----------------------------------------------------------------
// Deque (double ended queue) implementation.
// -----------------------------------------------------------------

#include <cm/include/cmdeque.h>


// "CmDeque" is the default deque constructor.
//
CmDeque::CmDeque() : CmLinkedList()
{}


// "CmDeque" is the deque copy constructor.
//
CmDeque::CmDeque(const CmDeque& Dq) : CmLinkedList(Dq)
{}


// "=" assignment operator copies the specified deque into this deque.
//
CmDeque& CmDeque::operator=(const CmDeque& Dq)
{
  return (CmDeque&) CmLinkedList::operator=(Dq);
}


// "pushLeft" places the specified object into the queue left.
//
Bool CmDeque::pushLeft(CmObject* pObj)
{
  return prepend(pObj);
}


// "pushRight" places the specified object into the queue right.
//
Bool CmDeque::pushRight(CmObject* pObj)
{
  return append(pObj);
}


// "popLeft" pops the left object from the deque.
//
CmObject* CmDeque::popLeft()
{
  return removeFirst();
}


// "popRight" pops the right object from the deque.
//
CmObject* CmDeque::popRight()
{
  return removeLast();
}


// "peekLeft" returns a pointer to the left object in the deque leaving the
// object in place.
// 
CmObject* CmDeque::peekLeft() const
{
  return first();
}


// "peekRight" returns a pointer to the right object in the deque leaving the
// object in place.
// 
CmObject* CmDeque::peekRight() const
{
  return last();
}
