// CmAssoc.cpp
// -----------------------------------------------------------------
// Compendium - C++ Container Class Library
// Copyright (C) 1992-1994, Glenn M. Poorman, All rights reserved
// -----------------------------------------------------------------
// Association implementation.
// -----------------------------------------------------------------

#include <cm/include/cmassoc.h>


// "CmAssociation" is the association constructor.
//
CmAssociation::CmAssociation(CmObject* K, CmObject* O)
                             : _key(K), _object(O)
{}


// "CmAssociation" is the association copy constructor.
//
CmAssociation::CmAssociation(const CmAssociation& A)
{
  _key    = (A._key)    ? A._key->newCopy()    : NULL;
  _object = (A._object) ? A._object->newCopy() : NULL;
}


// "=" assignment operator copies the contents of the specified
// assocation into this assocation.
//
CmAssociation& CmAssociation::operator=(const CmAssociation& A)
{
  if (&A != this)
  {
    _key    = (A._key)    ? A._key->newCopy()    : NULL;
    _object = (A._object) ? A._object->newCopy() : NULL;
  }
  return *this;
}


// "isEqual" returns whether or not the specified object is equal to
// this object.
//
Bool CmAssociation::isEqual(CmObject* pObj) const
{
  if (!pObj->isA("CmAssociation")) return CmObject::isEqual(pObj);
  CmAssociation* pAss = (CmAssociation*) pObj;
  return (_key) ? _key->isEqual(pAss->_key) : FALSE;
}


// "compare" compares the specified object to this object.
//
int CmAssociation::compare(CmObject* pObj) const
{
  if (!pObj->isA("CmAssociation")) return CmObject::compare(pObj);
  CmAssociation* pAss = (CmAssociation*) pObj;
  return (_key) ? _key->compare(pAss->_key) : -1;
}


// "hash" returns a hash value based on the input parameter.
//
unsigned CmAssociation::hash(unsigned m) const
{
  return (_key) ? _key->hash(m) : CmObject::hash(m);
}


// "printOn" prints this association on the specified output stream.
//
void CmAssociation::printOn(ostream& os) const
{
  if (_key && _object)
    os << "(" << *_key << ", " << *_object << ")";
}


// "write" writes the association objects to the specified file.
//
Bool CmAssociation::write(CmReserveFile& file) const
{
  if (!_key || !_object) return FALSE;
  Bool success = _key->writeObject(file);            // Write key.
  if (success) success = _object->writeObject(file); // Write object.
  return success;
}


// "read" reads association objects from the specified file.
//
Bool CmAssociation::read(CmReserveFile& file)
{
  _key = _object = NULL;
  _key = CmObject::readObject(file);                 // Read key object.
  if (!_key) return FALSE;

  _object = CmObject::readObject(file);              // Read value object.
  if (_object) return TRUE;

  delete _key;
  _key = NULL;
  return FALSE;
}
