// CmTVec.h
// -----------------------------------------------------------------
// Compendium - C++ Container Class Library
// Copyright (C) 1992-1994, Glenn M. Poorman, All rights reserved
// -----------------------------------------------------------------
// Dynamic array template definition.
// -----------------------------------------------------------------

#ifndef _CMTVEC_H
#define _CMTVEC_H

#include <cm/include/cmdefs.h>

template <class T> class CmTVector {              // Vector definition.
public:
  CmTVector(unsigned = 0);                        // Default constructor.
  CmTVector(const CmTVector<T>&);                 // Copy constructor.
 ~CmTVector();                                    // List destructor.

  CmTVector<T>& operator= (const CmTVector<T>&);  // Assignment operator.

  unsigned size      () const;                    // Return number of objs.
  T*       array     () const;                    // Return array pointer.
  T&       operator[](int);                       // Set or get an object.
  const T& operator[](int) const;                 // Get an object.
  void     clear     ();                          // Clear the list.
  Bool     resize    (unsigned);                  // Resize the list.

protected:
  void copy(const CmTVector<T>&);                 // Internal copy method.

  unsigned _size;                                 // Number of objects.
  T       *_array;                                // Array of objects.
};

#if defined(__TURBOC__) || defined(__xlC__)
#include <cm/include/cmtvec.cc>
#endif

#endif
