// CmTSet.h
// -----------------------------------------------------------------
// Compendium - C++ Container Class Library
// Copyright (C) 1992-1994, Glenn M. Poorman, All rights reserved
// -----------------------------------------------------------------
// Set template definition.
// -----------------------------------------------------------------

#ifndef _CMTSET_H
#define _CMTSET_H

#include <cm/include/cmthash.h>

template <class T> class CmTSet : public CmTHashTable<T> {  // Set definition.
public:
  CmTSet(unsigned = 10);                    // Default set constructor.
  CmTSet(const CmTSet<T>&);                 // Set copy constructor.
 ~CmTSet() {}                               // Set destructor.

  CmTSet<T>& operator=(const CmTSet<T>&);   // Assignment operator.

  Bool add(const T&);                       // Add object to set.
};

#if defined(__TURBOC__) || defined(__xlC__)
#include <cm/include/cmtset.cc>
#endif

#endif
