// CmTSet.cc
// -----------------------------------------------------------------
// Compendium - C++ Container Class Library
// Copyright (C) 1992-1994, Glenn M. Poorman, All rights reserved
// -----------------------------------------------------------------
// Set template implementation.
// -----------------------------------------------------------------


// "CmTSet" is the default set constructor.
//
template <class T> CmTSet<T>::CmTSet(unsigned sz)
                            : CmTHashTable<T>(sz)
{}


// "CmTSet" is the set copy constructor.
//
template <class T> CmTSet<T>::CmTSet(const CmTSet<T>& S)
                            : CmTHashTable<T>(S)
{}


// "=" assignment operator copies the specified set into this set.
//
template <class T> CmTSet<T>& CmTSet<T>::operator=(const CmTSet<T>& S)
{
  return (CmTSet<T>&) CmTHashTable<T>::operator=(S);
}


// "add" adds a new item to this set making sure not to duplicate an
// existing item.
//
template <class T> Bool CmTSet<T>::add(const T& rObj)
{
  return (contains(rObj)) ? FALSE : CmTHashTable<T>::add(rObj);
}
