// CmTRing.h
// -----------------------------------------------------------------
// Compendium - C++ Container Class Library
// Copyright (C) 1992-1994, Glenn M. Poorman, All rights reserved
// -----------------------------------------------------------------
// Ring (circular linked list) template definition.
// -----------------------------------------------------------------

#ifndef _CMTRING_H
#define _CMTRING_H

#include <cm/include/cmtcont.h>

template <class T> class CmTRingIterator;    // Ring iterator class stub.
template <class T> class CmTRingNode;        // Ring node class stub.

template <class T> class CmTRing : public CmTContainer<T> {
public:
  CmTRing() : _top(NULL), _last(NULL) {}     // Default ring constructor.
  CmTRing(const CmTRing<T>&);                // Ring copy constructor.
 ~CmTRing();                                 // Ring destructor.

  CmTRing<T>& operator=(const CmTRing<T>&);  // Assignment operator.

  Bool     add        (const T&);            // Add item to ring top.
  Bool     remove     (const T&);            // Remove equal item.
  Bool     removeTop  ();                    // Remove top object.
  const T& lookup     (const T&) const;      // Return equal item.
  Bool     contains   (const T&) const;      // See if ring contains equal.
  unsigned occurrences(const T&) const;      // Count number of equal objects.
  void     removeAll  ();                    // Remove all objects from ring.
  const T& top        () const;              // Get pointer to top object.

  CmTIterator<T>* newIterator() const;       // Create and return iterator.

protected:
  CmTRingNode<T> *_top;                      // Top node in ring.
  CmTRingNode<T> *_last;                     // Last node in ring.
  friend          CmTRingIterator<T>;        // Iterator can access.
};

template <class T> class CmTRingIterator : public CmTIterator<T> {
public:
  CmTRingIterator(const CmTRing<T>& R)       // Iterator constructor.
                  : _ring(R), _node(R._top) {}

  Bool     done    () const;                 // See if done iterating (FALSE).
  const T& next    ();                       // Get next object in ring.
  const T& previous();                       // Return and backup.
  const T& current () const;                 // Get current ring item.
  void     first   ();                       // Move to first item.
  void     last    ();                       // Move to last item.

protected:
  CmTRingNode<T>   *_node;                   // Current ring node.
  const CmTRing<T> &_ring;                   // Ring being iterated.
  friend            CmTRing<T>;              // Ring class can access.
};

template <class T> class CmTRingNode {       // Ring node definition.
protected:
  CmTRingNode(const T& O)                    // Ring node constructor.
              : _next(NULL), _data(O) {}

  CmTRingNode<T> *_next;                     // Next node in ring.
  T               _data;                     // Object.
  friend          CmTRing<T>;                // Ring class can access.
  friend          CmTRingIterator<T>;        // Ring iterator can access.
};

#if defined(__TURBOC__) || defined(__xlC__)
#include <cm/include/cmtring.cc>
#endif

#endif
