// CmTOrdAr.h
// -----------------------------------------------------------------
// Compendium - C++ Container Class Library
// Copyright (C) 1992-1994, Glenn M. Poorman, All rights reserved
// -----------------------------------------------------------------
// Ordered array template definition.
// -----------------------------------------------------------------

#ifndef _CMTORDAR_H
#define _CMTORDAR_H

#include <cm/include/cmtcont.h>

template <class T> class CmTOrderedArrayIterator; // Iterator class stub.

template <class T> class CmTOrderedArray : public CmTContainer<T> {
public:
  CmTOrderedArray(unsigned = 0, unsigned = 0);  // Default array constructor.
  CmTOrderedArray(const CmTOrderedArray<T>&);   // Array copy constructor.
 ~CmTOrderedArray() { delete[] _entries; }      // Array destructor.

  CmTOrderedArray<T>& operator=(const CmTOrderedArray<T>&); // Assignment.

  const T& operator[](int) const;               // Indexing operator.
                                                // (Can not be used as lvalue).

  void     delta      (unsigned);               // Set delta value.
  unsigned delta      () const;                 // Get delta value.
  int      total      () const;                 // Return number of items.
  const T& at         (int) const;              // Get object at index.
  Bool     add        (const T&);               // Append object to array.
  Bool     remove     (const T&);               // Remove specified object.
  Bool     removeAt   (int);                    // Remove object at index.
  int      index      (const T&) const;         // Get index of object.
  int      shouldGo   (const T&) const;         // Get index for potential obj.
  const T& lookup     (const T&) const;         // Look for equal object.
  Bool     contains   (const T&) const;         // Object is in array?
  unsigned occurrences(const T&) const;         // How many occurrences?
  void     removeAll  () { _total = 0; }        // Remove all objects.
  Bool     resize     (unsigned);               // Resize the array.
  Bool     isEmpty    () const;                 // Is array empty?

  CmTIterator<T>* newIterator() const;          // Get array iterator.

protected:
  void copy(const CmTOrderedArray<T>&);         // Internal copy method.

  unsigned  _delta;                             // Delta value.   
  unsigned  _total;                             // Number of objects.
  T        *_entries;                           // Array of "T" pointers.
  friend    CmTOrderedArrayIterator<T>;         // Iterator can access,
};

template <class T> class CmTOrderedArrayIterator : public CmTIterator<T> {
public:
  CmTOrderedArrayIterator(const CmTOrderedArray<T>& A) // Iterator constructor.
                 : _array(A), _index(0) {}

  Bool     done    () const;                    // Check if done iterating.
  const T& next    ();                          // Return and advance.
  const T& previous();                          // Return and backup.
  const T& current () const;                    // Return current object.
  void     first   ();                          // Move to first item.
  void     last    ();                          // Move to last item.

protected:
  const CmTOrderedArray<T>& _array;             // Array being iterated.
  int                       _index;             // Current array index.
  friend                    CmTOrderedArray<T>; // Array class can access.
};

#if defined(__TURBOC__) || defined(__xlC__)
#include <cm/include/cmtordar.cc>
#endif

#endif
