// CmTList.h
// -----------------------------------------------------------------
// Compendium - C++ Container Class Library
// Copyright (C) 1992-1994, Glenn M. Poorman, All rights reserved
// -----------------------------------------------------------------
// Singly linked list template definition.
// -----------------------------------------------------------------

#ifndef _CMTLIST_H
#define _CMTLIST_H

#include <cm/include/cmtcont.h>

template <class T> class CmTLink;                // List link class stub.
template <class T> class CmTLinkedListIterator;  // List iterator class stub.

template <class T> class CmTLinkedList : public CmTContainer<T> {
public:
  CmTLinkedList() : _first(NULL), _last(NULL) {} // Default list constructor.
  CmTLinkedList(const CmTLinkedList<T>&);        // List copy constructor.
 ~CmTLinkedList();                               // List destructor.

  CmTLinkedList<T>& operator=(const CmTLinkedList<T>&); // Assignment operator.

  const T& operator[]  (int) const;              // Get item by index.
  Bool     add         (const T&);               // Add item to end of list.
  Bool     append      (const T&);               // Add item to end of list.
  Bool     prepend     (const T&);               // Add item to start of list.
  Bool     insertAfter (const T&, const T&);     // Insert item after another.
  Bool     insertBefore(const T&, const T&);     // Insert item before another.
  Bool     remove      (const T&);               // Remove equal item from list.
  T        removeFirst ();                       // Remove first list item.
  T        removeLast  ();                       // Remove last list item.
  const T& lookup      (const T&) const;         // Lookup equal item in list.
  const T& first       () const;                 // Return first object in list.
  const T& last        () const;                 // Return last object in list.
  Bool     contains    (const T&) const;         // See if equal is in list.
  unsigned occurrences (const T&) const;         // Count occurrences of item.
  void     removeAll   ();                       // Remove all items from list.

  CmTIterator<T>* newIterator() const;           // Create and return iterator.

protected:
  CmTLink<T> *_first;                            // First item in list.
  CmTLink<T> *_last;                             // Last item in list.
  friend      CmTLinkedListIterator<T>;          // Iterator can access.
};

                                                 // Iterator definition.
template <class T> class CmTLinkedListIterator : public CmTIterator<T> {
public:
  CmTLinkedListIterator(const CmTLinkedList<T>&); // Iterator constructor.

  Bool     done    () const;                     // Check if end of list.
  const T& next    ();                           // Return and advance.
  const T& previous();                           // Return and backup.
  const T& current () const;                     // Return current.
  void     first   ();                           // Move to first item.
  void     last    ();                           // Move to last item.

protected:
  const CmTLinkedList<T> &_list;                 // List being iterated.
  CmTLink<T>             *_link;                 // Current list link.
  friend                  CmTLinkedList<T>;      // List class can access.
};

template <class T> class CmTLink {               // List link definition.
protected:
  CmTLink<T> *_next;                             // Next item in list.
  T           _data;                             // List data object.
  friend      CmTLinkedList<T>;                  // List class can access.
  friend      CmTLinkedListIterator<T>;          // Iterator class can access.

  CmTLink(const T& D) : _next(NULL), _data(D) {} // Construct link.
};

#if defined(__TURBOC__) || defined(__xlC__)
#include <cm/include/cmtlist.cc>
#endif

#endif
