// CmTIter.cc
// -----------------------------------------------------------------
// Compendium - C++ Container Class Library
// Copyright (C) 1992-1994, Glenn M. Poorman, All rights reserved
// -----------------------------------------------------------------
// Abstract container iterator template implementation.
// -----------------------------------------------------------------


// "int" conversion operator returns zero if at the end.
//
template <class T> CmTIterator<T>::operator int() const
{
  return !done();
}


// "++" advances the iterator to the next object and returns it.
//
template <class T> const T& CmTIterator<T>::operator++()
{
  next();
  return current();
}


// "++" returns the current object and advances the iterator to the next.
//
template <class T> const T& CmTIterator<T>::operator++(int)
{
  return next();
}


// "+=" advances the iterator n places and returns the object.
//
template <class T> const T& CmTIterator<T>::operator+=(int num)
{
  for (int ii = 0; ii < num; ii++) next();
  return current();
}


// "--" decrements the iterator by one and returns the object.
//
template <class T> const T& CmTIterator<T>::operator--()
{
  previous();
  return current();
}


// "--" returns the current object and decrements the iterator by one.
//
template <class T> const T& CmTIterator<T>::operator--(int)
{
  return previous();
}


// "-=" decrements the iterator n places and returns the object.
//
template <class T> const T& CmTIterator<T>::operator-=(int num)
{
  for (int ii = 0; ii < num; ii++) previous();
  return current();
}


// "()" returns the current iterator object.
//
template <class T> const T& CmTIterator<T>::operator()() const
{
  return current();
}


// "nextOccurrence" advances to the next occurrence of the specified item.
//
template <class T> const T& CmTIterator<T>::nextOccurrence(const T& rItem)
{
  while (!done() && !(current() == rItem)) next();
  const T& out = current(); next();
  while (!done() && !(current() == out)) next();
  return out;
}


// "previousOccurrence" advances to the previous occurrence of the
// specified item.
//
template <class T> const T& CmTIterator<T>::previousOccurrence(const T& rItem)
{
  while (!done() && !(current() == rItem)) previous();
  const T& out = current(); previous();
  while (!done() && !(current() == out)) previous();
  return out;
}
