// CmTHDict.h
// -----------------------------------------------------------------
// Compendium - C++ Container Class Library
// Copyright (C) 1992-1994, Glenn M. Poorman, All rights reserved
// -----------------------------------------------------------------
// Hash dictionary template definition.
// -----------------------------------------------------------------

#ifndef _CMTHDICT_H
#define _CMTHDICT_H

#include <cm/include/cmthash.h>
#include <cm/include/cmtassoc.h>

template <class T, class O>
class CmTHashDictionary : public CmTHashTable< CmTAssociation<T, O> > {
public:
  CmTHashDictionary(unsigned = 10);                 // Default constructor.
  CmTHashDictionary(const CmTHashDictionary<T,O>&); // Copy constructor.
 ~CmTHashDictionary() {}                            // Destructor.

                                                    // Assignment.
  CmTHashDictionary<T,O>& operator=(const CmTHashDictionary<T,O>&);

  Bool     addKey          (const T&);              // Add key.
  Bool     addKeyAndObject (const T&, const O&);    // Add key/object.
  Bool     addAssoc        (const CmTAssociation<T,O>&); // Add assoc.
  Bool     removeKey       (const T&);              // Remove assoc with key.
  const T& lookupKey       (const T&) const;        // Return equal key.
  const O& lookupObject    (const T&) const;        // Return object by key.
  Bool     replace         (const T&, const O&);    // Rep obj at key.
  Bool     containsKey     (const T&) const;        // See if key in dict.
  unsigned occurrencesOfKey(const T&) const;        // How many equal keys.

  const CmTAssociation<T,O>& lookupAssoc(const T&) const;  // Find assoc.
};

#if defined(__TURBOC__) || defined(__xlC__)
#include <cm/include/cmthdict.cc>
#endif

#endif
