// CmTDeque.cc
// -----------------------------------------------------------------
// Compendium - C++ Container Class Library
// Copyright (C) 1992-1994, Glenn M. Poorman, All rights reserved
// -----------------------------------------------------------------
// Deque (double ended queue) template implementation.
// -----------------------------------------------------------------


// "CmTDeque" is the deque copy constructor.
//
template <class T> CmTDeque<T>::CmTDeque(const CmTDeque<T>& S)
                              : CmTLinkedList<T>(S)
{}


// "=" operator copies the contents of the input queue into this queue.
//
template <class T> CmTDeque<T>& CmTDeque<T>::operator=(const CmTDeque<T>& S)
{
  return (CmTDeque<T>&) CmTLinkedList<T>::operator=(S);
}


// "pushLeft" pushes the specified item into queue left.
//
template <class T> Bool CmTDeque<T>::pushLeft(const T& obj)
{
  return prepend(obj);
}


// "pushRight" pushes the specified item into queue right.
//
template <class T> Bool CmTDeque<T>::pushRight(const T& obj)
{
  return append(obj);
}


// "popLeft" removes the left item from the queue and returns a copy.
//
template <class T> T CmTDeque<T>::popLeft()
{
  return removeFirst();
}


// "popRight" removes the right item from the queue and returns a copy.
//
template <class T> T CmTDeque<T>::popRight()
{
  return removeLast();
}


// "peekLeft" returns a copy of the left queue item.
//
template <class T> const T& CmTDeque<T>::peekLeft() const
{
  return first();
}


// "peekRight" returns a copy of the right queue item.
//
template <class T> const T& CmTDeque<T>::peekRight() const
{
  return last();
}
