// CmTBinTr.h
// -----------------------------------------------------------------
// Compendium - C++ Container Class Library
// Copyright (C) 1992-1994, Glenn M. Poorman, All rights reserved
// -----------------------------------------------------------------
// Binary tree template definition.
// -----------------------------------------------------------------

#ifndef _CMTBINTR_H
#define _CMTBINTR_H

#include <cm/include/cmtqueue.h>
#include <cm/include/cmtstack.h>

template <class T> class CmTBinaryTreeNode;     // Node class stub.
template <class T> class CmTBinaryTreeIterator; // Iterator class stub.

template <class T> class CmTBinaryTree : public CmTContainer<T> {
public:
  CmTBinaryTree();                              // Default constructor.
  CmTBinaryTree(const CmTBinaryTree<T>&);       // Copy constructor.
 ~CmTBinaryTree();                              // Tree destructor.

  CmTBinaryTree<T>& operator=(const CmTBinaryTree<T>&);  // Assignment. 

  Bool     add        (const T&);               // Add item to tree.
  Bool     remove     (const T&);               // Remove item from tree.
  const T& lookup     (const T&) const;         // Find equal item in tree.
  Bool     contains   (const T&) const;         // Is equal item in tree?
  void     removeAll  ();                       // Remove all items.
  unsigned occurrences(const T&) const;         // Count occurrences of item.
  const T& root       () const;                 // Return root tree item.
  void     balance    ();                       // Balance the tree.

  CmTIterator<T>* newIterator() const;          // Get tree iterator.

protected:
  void balanceHalf(CmTQueue<CmTBinaryTreeNode<T>*>*, int, int); // Balance.
  static void killNode(CmTBinaryTreeNode<T>*);  // Destroy node children.

  CmTBinaryTreeNode<T> *_root;                  // Tree root node.
  friend CmTBinaryTreeIterator<T>;              // Iterator can access.
};

template <class T> class CmTBinaryTreeIterator : public CmTIterator<T> {
public:
  CmTBinaryTreeIterator(const CmTBinaryTree<T>&); // Iterator constructor.
 ~CmTBinaryTreeIterator();                        // Iterator destructor.

  Bool     done    () const;                    // Check if end of container.
  const T& next    ();                          // Advance and return.
  const T& previous();                          // Return and backup.
  const T& current () const;                    // Return current object.
  void     first   ();                          // Move to first item.
  void     last    ();                          // Move to last item.

protected:
  const CmTBinaryTree<T>          &_tree;       // Tree being iterated.
  CmTBinaryTreeNode<T>            *_node;       // Current tree node.
  CmTStack<CmTBinaryTreeNode<T>*> *_stack;      // Node stack.
  friend CmTBinaryTree<T>;                      // Tree class can access.
};

template <class T> class CmTBinaryTreeNode {    // Node definition.
protected:
  CmTBinaryTreeNode<T> *_left;                  // Left node from this.
  T                     _data;                  // Node key (data).
  CmTBinaryTreeNode<T> *_right;                 // Right node from this.

  friend CmTBinaryTree<T>;                      // Tree class can access.
  friend CmTBinaryTreeIterator<T>;              // Iterator can access.

  CmTBinaryTreeNode(const T& D)                 // Node constructor.
                    : _left(NULL), _data(D), _right(NULL) {}
};

#if defined(__TURBOC__) || defined(__xlC__)
#include <cm/include/cmtbintr.cc>
#endif

#endif
