// CmTBDict.h
// -----------------------------------------------------------------
// Compendium - C++ Container Class Library
// Copyright (C) 1992-1994, Glenn M. Poorman, All rights reserved
// -----------------------------------------------------------------
// BTree dictionary template definition.
// -----------------------------------------------------------------

#ifndef _CMTBDICT_H
#define _CMTBDICT_H

#include <cm/include/cmtbtree.h>
#include <cm/include/cmtassoc.h>

template <class T, class O>
class CmTBTreeDictionary : public CmTBTree< CmTAssociation<T, O> > {
public:
  CmTBTreeDictionary(unsigned = 10);                // Default constructor.
  CmTBTreeDictionary(const CmTBTreeDictionary<T,O>&); // Copy constructor.
 ~CmTBTreeDictionary() {}                           // Destructor.

                                                    // Assignment.
  CmTBTreeDictionary<T,O>& operator=(const CmTBTreeDictionary<T,O>&);

  Bool     addKey          (const T&);              // Add key.
  Bool     addKeyAndObject (const T&, const O&);    // Add assoc.
  Bool     addAssoc        (const CmTAssociation<T,O>&); // Add assoc.
  Bool     removeKey       (const T&);              // Remove assoc with key.
  const T& lookupKey       (const T&) const;        // Return equal key.
  const O& lookupObject    (const T&) const;        // Return object by key.
  Bool     replace         (const T&, const O&);    // Rep obj at key.
  Bool     containsKey     (const T&) const;        // See if key in dict.
  unsigned occurrencesOfKey(const T&) const;        // How many equal keys.

  const CmTAssociation<T,O>& lookupAssoc(const T&) const;  // Lookup assoc.
};

#if defined(__TURBOC__) || defined(__xlC__)
#include <cm/include/cmtbdict.cc>
#endif

#endif
