// CmTAssoc.h
// -----------------------------------------------------------------
// Compendium - C++ Container Class Library
// Copyright (C) 1992-1994, Glenn M. Poorman, All rights reserved
// -----------------------------------------------------------------
// Association template definition.
// -----------------------------------------------------------------

#ifndef _CMTASSOC_H
#define _CMTASSOC_H

#include <cm/include/cmdefs.h>

template <class T, class O> class CmTAssociation {   // Assoc definition.
public:
  CmTAssociation() {}                                // Default constructor.
  CmTAssociation(const T&, const O&);                // Construct w/ key&object.
  CmTAssociation(const T&);                          // Construct with key.
  CmTAssociation(const CmTAssociation<T,O>&);        // Copy constructor.

  CmTAssociation<T,O>& operator=(const CmTAssociation<T,O>&); // Assignment.

  void     set   (const T&, const O&);               // Set new key and object.
  const T& key   () const;                           // Return key value.
  void     key   (const T&);                         // Set new key value.
  const O& object() const;                           // Return object value.
  void     object(const O&);                         // Set new object value.

  Bool operator==(const CmTAssociation<T,O>&) const; // Equality check.
  Bool operator!=(const CmTAssociation<T,O>&) const; // In-equality check.
  Bool operator< (const CmTAssociation<T,O>&) const; // Less than check.
  Bool operator> (const CmTAssociation<T,O>&) const; // Greater than check.
  Bool operator<=(const CmTAssociation<T,O>&) const; // Less than or equal.
  Bool operator>=(const CmTAssociation<T,O>&) const; // Greater or equal.

protected:
  T _key;                                            // Key value.
  O _object;                                         // Object value.
};

#if defined(__TURBOC__) || defined(__xlC__)
#include <cm/include/cmtassoc.cc>
#endif

#endif
