// CmTAssoc.cc
// -----------------------------------------------------------------
// Compendium - C++ Container Class Library
// Copyright (C) 1992-1994, Glenn M. Poorman, All rights reserved
// -----------------------------------------------------------------
// Association template implementation.
// -----------------------------------------------------------------


// "CmTAssociation" constructs a new association with the specified
// key and object.
//
template <class T, class O>
CmTAssociation<T,O>::CmTAssociation(const T& k, const O& o)
{
  _key    = k;
  _object = o;
}


// "CmTAssociation" constructs a new association with the specified
// key.
//
template <class T, class O>
CmTAssociation<T,O>::CmTAssociation(const T& k)
{
  _key = k;
}


// "CmTAssociation" is the association copy constructor.
//
template <class T, class O>
CmTAssociation<T,O>::CmTAssociation(const CmTAssociation<T,O>& A)
{
  _key    = A._key;
  _object = A._object;
}


// "=" assignment operator copies the specified association into this
// association.
//
template <class T, class O> CmTAssociation<T,O>&
CmTAssociation<T,O>::operator=(const CmTAssociation<T,O>& A)
{
  if (&A != this)
  {
    _key    = A._key;
    _object = A._object;
  }
  return *this;
}


// "set" sets a new key and object value.
//
template <class T, class O>
void CmTAssociation<T,O>::set(const T& k, const O& o)
{
  _key    = k;
  _object = o;
}


// "key" returns the key value.
//
template <class T, class O> const T& CmTAssociation<T,O>::key() const
{
  return _key;
}


// "key" sets a new key value.
//
template <class T, class O> void CmTAssociation<T,O>::key(const T& k)
{
  _key = k;
}


// "object" returns the object value.
//
template <class T, class O> const O& CmTAssociation<T,O>::object() const
{
  return _object;
}


// "object" sets a new object value.
//
template <class T, class O> void CmTAssociation<T,O>::object(const O& o)
{
  _object = o;
}


// "==" checks to see if two associations are equal.
//
template <class T, class O>
Bool CmTAssociation<T,O>::operator==(const CmTAssociation<T,O>& A) const
{
  return (_key == A._key);
}


// "!=" checks to see if two associations are not equal.
//
template <class T, class O>
Bool CmTAssociation<T,O>::operator!=(const CmTAssociation<T,O>& A) const
{
  return (_key != A._key);
}


// "<" checks if this association is less than the specified association.
//
template <class T, class O>
Bool CmTAssociation<T,O>::operator<(const CmTAssociation<T,O>& A) const
{
  return (_key < A._key);
}


// ">" checks if this association is greater than the specified association.
//
template <class T, class O>
Bool CmTAssociation<T,O>::operator>(const CmTAssociation<T,O>& A) const
{
  return (_key > A._key);
}


// "<=" checks if this association is less than or equal to the specified
// association.
//
template <class T, class O>
Bool CmTAssociation<T,O>::operator<=(const CmTAssociation<T,O>& A) const
{
  return (_key <= A._key);
}


// ">=" checks if this association is greater than or equal to the specified
// association.
//
template <class T, class O>
Bool CmTAssociation<T,O>::operator>=(const CmTAssociation<T,O>& A) const
{
  return (_key >= A._key);
}
