// CmTArray.h
// -----------------------------------------------------------------
// Compendium - C++ Container Class Library
// Copyright (C) 1992-1994, Glenn M. Poorman, All rights reserved
// -----------------------------------------------------------------
// Array template definition.
// -----------------------------------------------------------------

#ifndef _CMTARRAY_H
#define _CMTARRAY_H

#include <stdlib.h>
#include <cm/include/cmtcont.h>

template <class T> class CmTArrayIterator;    // Iterator class stub.

template <class T> class CmTArray : public CmTContainer<T> {
public:
  CmTArray(unsigned = 0, unsigned = 0);       // Default array constructor.
  CmTArray(const CmTArray<T>&);               // Array copy constructor.
 ~CmTArray();                                 // Array destructor.

  CmTArray<T>& operator=(const CmTArray<T>&); // Assignment operator.

  const T& operator[](int) const;             // Indexing operator.
                                              // (Can not be used as lvalue).

  void     delta      (unsigned);             // Set delta value.
  unsigned delta      () const;               // Get delta value.
  int      total      () const;               // Return number of items.
  const T& at         (int) const;            // Get object at index.
  Bool     add        (const T&);             // Append object to array.
  Bool     insertAt   (int, const T&);        // Insert object at index.
  Bool     replaceAt  (int, const T&);        // Replace object at index.
  Bool     remove     (const T&);             // Remove specified object.
  Bool     removeAt   (int);                  // Remove object at index.
  int      index      (const T&) const;       // Get index of object.
  const T& lookup     (const T&) const;       // Look for equal object.
  Bool     contains   (const T&) const;       // Object is in array?
  unsigned occurrences(const T&) const;       // How many occurrences?
  void     removeAll  ();                     // Remove all objects.
  Bool     resize     (unsigned);             // Resize the array.
  Bool     isEmpty    () const;               // Is array empty?
  void     quickSort  ();                     // Quick sort the array.

  CmTIterator<T>* newIterator() const;        // Get array iterator.

protected:
  void copy(const CmTArray<T>&);              // Internal copy method.

  static int cmpObjs(const void*, const void*); // Quick sort compare func.

  unsigned  _delta;                           // Delta value.   
  unsigned  _total;                           // Number of objects.
  T        *_entries;                         // Array of "T" pointers.
  friend    CmTArrayIterator<T>;              // Iterator can access,
};

template <class T> class CmTArrayIterator : public CmTIterator<T> {
public:
  CmTArrayIterator(const CmTArray<T>&);       // Iterator constructor.

  Bool     done    () const;                  // Check if done iterating.
  const T& next    ();                        // Return and advance.
  const T& previous();                        // Return and backup.
  const T& current () const;                  // Return current item.
  void     first   ();                        // Move to first item.
  void     last    ();                        // Move to last item.

protected:
  const CmTArray<T>& _array;                  // Array being iterated.
  int                _index;                  // Current array index.
  friend             CmTArray<T>;             // Array class can access.
};

#if defined(__TURBOC__) || defined(__xlC__)
#include <cm/include/cmtarray.cc>
#endif

#endif
