// CmStack.h
// -----------------------------------------------------------------
// Compendium - C++ Container Class Library
// Copyright (C) 1992-1994, Glenn M. Poorman, All rights reserved
// -----------------------------------------------------------------
// Stack definition.
// -----------------------------------------------------------------

#ifndef _CMSTACK_H
#define _CMSTACK_H

#include <cm/include/cmlist.h>

class CmStack : public CmLinkedList {       // Stack class definition.
public:
  CmStack();                                // Default stack constructor.
  CmStack(const CmStack&);                  // Stack copy constructor.
 ~CmStack() {}                              // Stack destructor.

  CmStack& operator=(const CmStack&);       // Assignment operator.

  Bool      push(CmObject*);                // Push object onto stack top.
  CmObject* pop ();                         // Pop and return object from top.
  CmObject* peek() const;                   // Return pointer to top object.

  CMOBJECT_DEFINE(CmStack, CmLinkedList)    // Define object funcs.
};

#endif
