// CmSet.h
// -----------------------------------------------------------------
// Compendium - C++ Container Class Library
// Copyright (C) 1992-1994, Glenn M. Poorman, All rights reserved
// -----------------------------------------------------------------
// Set definition.
// -----------------------------------------------------------------

#ifndef _CMSET_H
#define _CMSET_H

#include <cm/include/cmhash.h>

class CmSet : public CmHashTable {          // Set class definition.
public:
  CmSet(unsigned = 10);                     // Default set constructor.
  CmSet(const CmSet&);                      // Set copy constructor.
 ~CmSet() {}                                // Set destructor.

  CmSet& operator=(const CmSet&);           // Assignment operator.
  CmSet  operator-(const CmSet&);           // Set difference.
  CmSet  operator&(const CmSet&);           // Set intersection.
  CmSet  operator|(const CmSet&);           // Set union.

  Bool add(CmObject*);                      // Add object to set.

  CMOBJECT_DEFINE(CmSet, CmHashTable)       // Define object funcs.
};

#endif
