// CmQueue.h
// -----------------------------------------------------------------
// Compendium - C++ Container Class Library
// Copyright (C) 1992-1994, Glenn M. Poorman, All rights reserved
// -----------------------------------------------------------------
// Queue definition.
// -----------------------------------------------------------------

#ifndef _CMQUEUE_H
#define _CMQUEUE_H

#include <cm/include/cmlist.h>

class CmQueue : public CmLinkedList {       // Queue class definition.
public:
  CmQueue();                                // Default queue constructor.
  CmQueue(const CmQueue&);                  // Queue copy constructor.
 ~CmQueue() {}                              // Queue destructor.

  CmQueue& operator=(const CmQueue&);       // Assignment operator.

  Bool      push(CmObject*);                // Push object into queue end.
  CmObject* pop ();                         // Pop and return object from from.
  CmObject* peek() const;                   // Return pointer to front object.

  CMOBJECT_DEFINE(CmQueue, CmLinkedList)    // Define object funcs.
};

#endif
